package com.digiwin.athena.eventcenter.provider;

import com.digiwin.app.service.DWService;
import com.digiwin.app.service.eai.EAICallback;
import com.digiwin.app.service.eai.EAIService;

import java.util.Map;

/**
 * @description: eai同步接口
 * @author: zhangzhi@digiwin.com
 * @date: 2021/1/5 09:58
 */
public interface IEventEaiProvider extends DWService {
    /**
     * 触发事件接口
     *
     * @param headers
     * @param messageBody
     * @return
     * @throws Exception
     */
    @EAIService(id= "event.trigger.process")
    String triggerEventExecution(Map<String, String> headers, String messageBody);

    /**
     * 订阅者执行完成Log同步接口
     *
     * @param headers
     * @param messageBody
     * @return
     * @throws Exception
     */
    @EAICallback(id= "event.trigger.callback")
    String consumerCallbackEventExecution(Map<String, String> headers, String messageBody);

}
