package com.digiwin.athena.eventcenter.repository.model.consumer;

import com.digiwin.athena.eventcenter.core.base.BaseModel;
import com.digiwin.athena.eventcenter.pojo.bo.km.EventSubscribeBo;
import com.digiwin.athena.eventcenter.pojo.dto.trigger.TriggerEventDto;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.mongodb.core.mapping.Document;

/**
 * @author zhangzhi@digiwin.com
 * @description: 事件消费记录
 * @date 2023/11/8 17:58
 */
@Document(collection = "event_consume_log")
@Getter
@Setter
@NoArgsConstructor
public class EventSubscribeLogModel extends BaseModel {

    /**
     * 事件实例id
     */
    private String eventLogId;

    /**
     * 追踪id
     */
    private String traceId;

    /**
     * 状态
     */
    private Integer status;

    /**
     * 消费者
     */
    private String subscriber;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 消息
     */
    private String message;

    public EventSubscribeLogModel(Integer status, String message, TriggerEventDto dto, String eventLogId,
                                  EventSubscribeBo subscribeBo) {
        this.eventLogId = eventLogId;
        this.traceId = dto.getEventHeader().getTraceId();
        this.status = status;
        this.message = message;
        this.subscriber = subscribeBo.getSubscribeProd();
        this.tenantId = dto.getEventHeader().getTenantId();
    }
}
