package com.digiwin.athena.eventcenter.service.client;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.eventcenter.core.util.JsonUtil;
import com.digiwin.athena.eventcenter.core.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.*;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.client.UnknownHttpStatusCodeException;
import org.springframework.web.server.ResponseStatusException;

/**
 * @author zhangzhi@digiwin.com
 * @date 2023/9/4
 */
@Slf4j
public abstract class AbstractClient {
    @Autowired
    private RestTemplate restTemplate;

    protected HttpHeaders initHeader() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        log.info("获取routerKey:{}, token:{} ", DWServiceContext.getContext().getRequestHeader().get("routerKey"),
                DWServiceContext.getContext().getRequestHeader().get("token"));
        headers.set("routerKey", (String) DWServiceContext.getContext().getRequestHeader().get("routerKey"));
        String token = (String) DWServiceContext.getContext().getRequestHeader().get("token");
        if (StringUtil.isNotBlank(token)) {
            headers.set("token", token);
        }
        return headers;
    }

    protected <T> T execute(String url, HttpMethod type, HttpEntity httpEntity, Class<T> cls) {
        try {
            return restTemplate.exchange(url, type, httpEntity, cls).getBody();
        } catch (HttpClientErrorException e) {
            log.error("请求[" + url + "]出现客户端4XX异常！响应报文为：" + e.getResponseBodyAsString(), e);
            throw new ResponseStatusException(e.getStatusCode());
        } catch (HttpServerErrorException e) {
            log.error("请求[" + url + "]出现服务端5XX异常！响应报文为：" + e.getResponseBodyAsString(), e);
            try {
                JSONObject errorResp = JsonUtil.getObject(e.getResponseBodyAsString());
                throw new ResponseStatusException(e.getStatusCode(), errorResp.getString("errorMessage"));
            } catch (Exception e1) {
                if (e1 instanceof ResponseStatusException) {
                    throw e1;
                }
                throw new ResponseStatusException(e.getStatusCode());
            }
        } catch (UnknownHttpStatusCodeException e) {
            log.error("请求[" + url + "]出现未知状态码异常！响应报文为：" + e.getResponseBodyAsString(), e);
            throw new ResponseStatusException(HttpStatus.NOT_FOUND);
        }
    }
}
