package com.digiwin.athena.eventcenter.service.client;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.eventcenter.core.util.JsonUtil;
import com.digiwin.athena.eventcenter.pojo.bo.km.EventResponseBo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

/**
 * @author zhangzhi@digiwin.com
 * @date 2023/09/04
 */
@Component("eventKmClient")
@Slf4j
public class KmClient extends AbstractClient{

    private static final String KM_EVENT_PATH = "/restful/standard/datamap/process/eventById";

    @Value("${monitor.kmUrl}")
    private String kmUrl;

    public EventResponseBo getEventById(String eventId){
        JSONObject param = new JSONObject();
        param.put("eventId", eventId);
        HttpEntity<JSONObject> httpEntity = new HttpEntity<>(param, initHeader());
        log.info("调用KM获取事件定义请求参数:[{}]", JsonUtil.getJsonString(param));
        EventResponseBo eventResponseBo = execute(kmUrl + KM_EVENT_PATH, HttpMethod.POST, httpEntity, EventResponseBo.class);
        log.info("调用KM获取事件定义结果:[{}]", JsonUtil.getJsonString(eventResponseBo));
        return eventResponseBo;
    }

}
