package com.digiwin.athena.eventcenter.core.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.ThreadPoolExecutor;

/**
 * @author zhangzhi@digiwin.com
 * @date 2023/9/5
 */
@Configuration
public class EventCenterConfig {
    /**
     * 事件线程池，设置更大的核心线程数和缓冲队列，数据不可丢失，
     * 自定义拒绝策略，拒绝策略中执行任务，并打印日志
     * @return 线程池
     */
    @Bean("eventExecutor")
    public ThreadPoolTaskExecutor eventExecutor(){
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        // 核心线程数 当前机器核心数
        executor.setCorePoolSize(4);
        // 最大线程数=核心线程数*2
        executor.setMaxPoolSize(8);
        // 队列长度
        executor.setQueueCapacity(3000);
        // 允许线程空闲时间
        executor.setKeepAliveSeconds(30);
        // 线程池名称前缀
        executor.setThreadNamePrefix("threadpool_eventExecutor_");
        // 自定义拒绝策略
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }
}
