package com.digiwin.athena.eventcenter.pojo.bo.km;


import com.alibaba.fastjson.JSONObject;
import lombok.*;

/**
 * @author zhangzhi@digiwin.com
 */
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Setter
@Getter
public class EventSubscribeBo {

    /**
     * 事件id
     */
    private String eventId;

    /**
     * application-taskengine-workflow-ScWork-dingding
     */
    private String subscribeType;

    /**
     * 指事件消费者（可以为应用ID<或者prod>）;
     */
    private String subscribeProd;

    /**
     * 分派类型 processor-http-esp
     */
    private String dispatchType;

    /**
     * 分派路径
     */
    private String dispatchUrl;

    /**
     * 分派同异步
     */
    private Boolean dispatchAsync;

    /**
     * invoke-process 发起流程；invoke-project 发起项目
     */
    private String processorType;

    /**
     * 流程配置
     */
    private ProcessorConfigBo processorConfig;


    @Builder
    @AllArgsConstructor
    @NoArgsConstructor
    @Setter
    @Getter
    public static class ProcessorConfigBo {

        /**
         * 事件id
         */
        private String processId;

        /**
         * 触发表单
         */
        private JSONObject triggerForm;

    }


}
