package com.digiwin.athena.eventcenter.pojo.bo.publish;


import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.eventcenter.core.util.JsonUtil;
import lombok.*;

/**
 * @author zhangzhi@digiwin.com
 */
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Setter
@Getter
public class InvokeProcessBodyBo {

    /**
     * 流程id
     */
    private String processId;

    /**
     * 运营单元
     * 必填字段
     * 数据结构
     * {
     *   "eoc_company_id":"必填",
     *    "eoc_site_id":"可选"
     * }
     */
    private JSONObject processEOC;

    /**
     * 发起人
     * 必填
     */
    private String initiatorId;

    /**
     * 发起人编码
     * 必填
     */
    private String initiatorNo;

    /**
     * 发起人名称
     * 必填
     */
    private String initiatorName;

    /**
     * 流程紧急度：25（紧急）-50（一般:默认）-75（低） ，默认50
     * 非必填
     */
    private Integer emergency;

    /**
     * 参数
     * 数据格式
     * {
     *    "key":"value"，
     *    "sourceIds":""，// 业务单号
     *  }
     */
    private JSONObject variables;

    /**
     * 发起模型表单数据
     *
     */
    private JSONObject dispatchData;

    /**
     * 父流程序号
     */
    private String mainProcessSerialNumber;

    @Override
    public String toString() {
        return JsonUtil.getJsonString(this);
    }

}
