package com.digiwin.athena.eventcenter.provider.impl;

import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.athena.eventcenter.core.constant.Constant;
import com.digiwin.athena.eventcenter.core.util.JsonUtil;
import com.digiwin.athena.eventcenter.pojo.dto.trigger.TriggerEventDto;
import com.digiwin.athena.eventcenter.provider.IEventEaiProvider;
import com.digiwin.athena.eventcenter.service.facade.IEventTriggerFacadeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zhangzhi@digiwin.com
 */
@Service
public class EventEaiProvider implements IEventEaiProvider {

    @Autowired
    private IEventTriggerFacadeService eventTriggerFacadeService;

    @Override
    public String triggerEventExecution(Map<String, String> headers, String messageBody) {
        TriggerEventDto dto = getTriggerEventDto(messageBody);
        eventTriggerFacadeService.triggerEvent(dto);
        return generateEAIResult(Constant.EAI_SUCCESS_CODE, "");
    }

    /**
     * 获取请求中的request_objects节点
     *
     * @param messageBody
     * @return
     */
    private TriggerEventDto getTriggerEventDto(String messageBody) {
        String parameter = JsonUtil.getObject(messageBody)
                .getJSONObject(Constant.ESP_STD_DATA)
                .getString(Constant.ESP_PARAMETER);
        return JsonUtil.getObject(parameter, TriggerEventDto.class);
    }

    @Override
    public String consumerCallbackEventExecution(Map<String, String> headers, String messageBody) {
        return null;
    }

    /**
     * 返回结果对象
     *
     * @param code
     * @param desc
     * @return
     */
    public static String generateEAIResult(String code, String desc) {
        return DWGsonProvider.getGson().toJson(new DWEAIResult(code, "", desc, new HashMap<>()), DWEAIResult.class);
    }

}
