package com.digiwin.athena.eventcenter.service.client.dispatch.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.eventcenter.core.util.JsonUtil;
import com.digiwin.athena.eventcenter.pojo.bo.publish.InvokeProcessBodyBo;
import com.digiwin.athena.eventcenter.service.client.AbstractClient;
import com.digiwin.athena.eventcenter.service.client.dispatch.IDispatchClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

/**
 * @author zhangzhi@digiwin.com
 * @date 2023/09/04
 */
@Component("eventDispatchByHttp")
@Slf4j
public class DispatchByHttp extends AbstractClient implements IDispatchClient {

    private static final String WORKFLOW_INVOKE_FLOW_PATH = "/standard/workflow/api/process/invoke";

    @Value("${monitor.workFlow.domain.url}")
    private String workflowUrl;

    @Override
    public void invokeProcess(InvokeProcessBodyBo bodyBo) {
        HttpEntity<InvokeProcessBodyBo> httpEntity = new HttpEntity<>(bodyBo, initHeader());
        log.info("发起流程请求参数:[{}]", JsonUtil.getJsonString(bodyBo));
        JSONObject result = execute(workflowUrl + WORKFLOW_INVOKE_FLOW_PATH, HttpMethod.POST, httpEntity, JSONObject.class);
        log.info("发起流程结果:[{}]", JsonUtil.getJsonString(result));
    }

}
