package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;
import com.digiwin.athena.executionengine.constant.MetaDataConstant;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.core.container.ExecuteErrorMessage;
import com.digiwin.athena.executionengine.enumtype.ActionTypeEnum;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import com.digiwin.athena.executionengine.util.MqSendUtils;
import com.digiwin.athena.executionengine.util.JsonResolverUtils;
import com.digiwin.athena.executionengine.util.ServiceResponseUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @description:
 * @author: renwm
 * @date: 2020/6/15 9:30
 */
@Service("TaskAction")
public class TaskAction extends ActionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskAction.class);

    @Override
    protected Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        JSONObject metaObj = actionParam.getMetaObj();
        String processId = metaObj.getString(MetaDataConstant.ACTION_PROCESS_ID);
        String taskId = metaObj.getString(MetaDataConstant.ACTION_TASK_ID);

        JSONObject actionJson = actionParam.getActionJson();
        String requesterId = actionJson.getString(MetaDataConstant.ACTION_REQUESTERID);
        String subject = actionJson.getString(MetaDataConstant.ACTION_SUBJECT);
        String locale = actionJson.getString(MetaDataConstant.ACTION_LOCALE);
        Boolean async = actionJson.getBoolean(MetaDataConstant.ACTION_ASYNC);

        try {
            Map<String, String> headerMap = new HashMap<>();
            headerMap.put("token", context.getToken());
            headerMap.put("Content-Type", "application/json;charset=UTF-8");
            headerMap.put(FieldNameConstant.CAMEL_CASE_ROUTER_KEY, context.getRouterKey());

            Map<String, Object> param = new HashMap<>();
            param.put("locale", locale);
            param.put("processId", processId);
            param.put("requesterId", requesterId);
            param.put("subject", subject);
            param.put("processVariable", reqMap);
            reqMap.put("process_EOC", context.getEocMap());
            if (StringUtils.isNotBlank(taskId)) {
                reqMap.put("taskId", taskId);
            }
            if (async != null) {
                param.put("async", async);
            }

            String jsonParam = JsonResolverUtils.toJsonString(param);
            String httpRespContent = HttpClientUtils.doPost(ModuleProperty.BPM_START_PROCESS, headerMap, jsonParam);
            if (httpRespContent == null) {
                context.setExecuteStatus(false);
                LOGGER.error("执行引擎调用Task执行{}:{}返回的结果为：null", actionParam.getActionId(), jsonParam);
                return null;
            }
            LOGGER.info("执行引擎调用Task执行{}:{}返回的结果为：{}", actionParam.getActionId(), jsonParam, httpRespContent);
            JSONObject respObj = ServiceResponseUtils.getBpmResp(httpRespContent);
            if (respObj == null) {
                context.setExecuteStatus(false);
            } else {
                context.setExecuteStatus(true);
            }
            MqSendUtils.sendSuccessMessage(context, "BPM", param);
            return respObj;
        } catch (Exception e) {
            LOGGER.error("执行引擎触发Task[{}]发起流程调用异常:{}", subject, e);
            context.setExecuteStatus(false);
            ExecuteErrorMessage executeErrorMessage = new ExecuteErrorMessage();
            executeErrorMessage.setErrorMsg(e.getMessage());
            executeErrorMessage.setErrorCode("P.EE.600.0005");
            executeErrorMessage.setActionTypeEnum(ActionTypeEnum.START_TASK);
            context.setExecuteErrorMessage(executeErrorMessage);
            MqSendUtils.sendExceptionMessage(context, e.getMessage());
            throw e;
        }
    }


}
