package com.digiwin.athena.executionengine.core.aop;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.container.exceptions.IDWException;
import com.digiwin.app.service.DWServiceChainContext;
import com.digiwin.athena.executionengine.constant.CommonConstant;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * @description: 异常处理类
 * @author: ZhangJun
 * @create: 2023/4/24
 */
@Aspect
@Component
public class ExceptionHandlerAspect {

    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionHandlerAspect.class);


    private static final String SUBSTRING = "trace info: me: ";

    @Pointcut("@within(com.digiwin.athena.executionengine.core.aop.MyExceptionHandler)")
    public void pointcut() {
    }

    @Around("pointcut()")
    public Object around(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        try {
            return proceedingJoinPoint.proceed();
        } catch (Exception e) {
            String chainInfo = DWServiceChainContext.getContext().getTraceElement().getTraceInfo(true);
            LOGGER.info("error  pinpoint transactionId:{} ", ThreadContext.get("PtxId"));
            if (chainInfo.indexOf(SUBSTRING) != -1) {
                chainInfo = StringUtils.substringAfter(chainInfo, SUBSTRING);
            }
            if (e instanceof IDWException) {
                IDWException exception = (IDWException) e;
                if (!exception.getInstructors().containsKey(CommonConstant.CHAIN_INFO)
                        || exception.getInstructors().get(CommonConstant.CHAIN_INFO) == null) {
                    exception.getInstructors().put(CommonConstant.CHAIN_INFO, chainInfo);
                }
                if (!exception.getInstructors().containsKey(CommonConstant.PTX_ID)
                        || exception.getInstructors().get(CommonConstant.PTX_ID) == null) {
                    exception.getInstructors().put(CommonConstant.PTX_ID, ThreadContext.get(CommonConstant.PTX_ID));
                }
                exception.getInstructors().put(CommonConstant.SERVER_TIME, System.currentTimeMillis());
                throw e;
            } else {
                LOGGER.error("非IDWException异常信息", e);
                DWRuntimeException exception = new DWRuntimeException(ErrorCodeEnum.UNKNOWN_EXCEPTION.getCode(),
                        e.getMessage());
                exception.getInstructors().put(CommonConstant.CHAIN_INFO, chainInfo);
                exception.getInstructors().put(CommonConstant.PTX_ID, ThreadContext.get(CommonConstant.PTX_ID));
                exception.getInstructors().put(CommonConstant.SERVER_TIME, System.currentTimeMillis());
                throw exception;
            }
        }
    }
}
