package com.digiwin.athena.executionengine.core.container;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: Lee
 * @create: 2024/9/25
 */
public class SolutionStepContext {

    private String tenantId;

    private String token;

    private Map<String, Object> param;
    private List<Map<String, Object>> paras;
    private List<Map<String, Object>> eocMaps;
    private Map<String, Object> eocMap;
    private List<String> roles;

    private Map<String, Object> permissions;

    private JSONArray productLineInfo;

    private Map<String, String> DATASET_ID_MODEL_ID_MAPPING = new HashMap<>();
    private Map<String, String> DATASET_ID_MODEL_CODE_MAPPING = new HashMap<>();
    private Map<String, JSONObject> DATASET_FIELDS_MAPPING = new HashMap<>();
    private Map<String, JSONArray> DATASET_DICTIONARY_MAPPING = new HashMap<>();

    public Map<String, JSONArray> getDatasetDictionaryMapping() {
        return DATASET_DICTIONARY_MAPPING;
    }

    public Map<String, JSONObject> getDatasetFieldsMapping() {
        return DATASET_FIELDS_MAPPING;
    }

    public Map<String, String> getModelIdMapping() {
        return DATASET_ID_MODEL_ID_MAPPING;
    }

    public Map<String, String> getModelCodeMapping() {
        return DATASET_ID_MODEL_CODE_MAPPING;
    }

    /**
     * 是否需要取数，默认不需要取数
     */
    private boolean isNeedData = false;

    public boolean isNeedData() {
        return isNeedData;
    }

    public void setNeedData(boolean needData) {
        isNeedData = needData;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Map<String, Object> getParam() {
        return param;
    }

    public void setParam(Map<String, Object> param) {
        this.param = param;
    }

    public List<Map<String, Object>> getParas() {
        return paras;
    }

    public void setParas(List<Map<String, Object>> paras) {
        this.paras = paras;
    }

    public List<Map<String, Object>> getEocMaps() {
        return eocMaps;
    }

    public void setEocMaps(List<Map<String, Object>> eocMaps) {
        this.eocMaps = eocMaps;
    }

    public List<String> getRoles() {
        return roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public Map<String, Object> getPermissions() {
        return permissions;
    }

    public void setPermissions(Map<String, Object> permissions) {
        this.permissions = permissions;
    }

    public Map<String, Object> getEocMap() {
        return eocMap;
    }

    public void setEocMap(Map<String, Object> eocMap) {
        this.eocMap = eocMap;
    }

    public JSONArray getProductLineInfo() {
        return productLineInfo;
    }

    public void setProductLineInfo(JSONArray productLineInfo) {
        this.productLineInfo = productLineInfo;
    }

}