package com.digiwin.athena.executionengine.service.facade.execution.asyc;

import com.digiwin.athena.executionengine.constant.ResultStatusConstant;
import com.digiwin.athena.executionengine.service.facade.event.ActionEventPublisher;
import com.digiwin.athena.executionengine.util.ThreadPoolUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.concurrent.CompletableFuture;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/5/20
 */
@Service("engineAsyncExecutor")
public class AsyncExecutor implements IAsyncExecutor {

    @Autowired
    private ActionEventPublisher actionEventPublisher;

    @Override
    public void addTask(AsyncTask task) {
        synchronized (AsyncExecutor.class) {
            if (task.getActionParam().getActionState() != ResultStatusConstant.UN_EXECUTED.getCode()) {
                return;
            }
            //action状态设置成执行中
            task.getActionParam().setActionState(ResultStatusConstant.EXECUTING.getCode());
        }

        CompletableFuture.runAsync(() ->
                        task.exec(), ThreadPoolUtils.getExecutorService()).
                thenRun(() -> actionEventPublisher.publishActionEvent(task.getActionParam().getActionId(), task.getExecuteContext()));
    }

}
