package com.digiwin.athena.executionengine.trans;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.util.CloneUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * @description: Trans数据管理对象
 * @author: fenglei
 * @date: 2020-12-3
 */
public class TransDataManger {
    private String token;

    public String getToken() {
        return token;
    }

    /**
     * transRule
     */
    private JSONObject ruleJsonObj;

    /**
     * 每个步骤执行过程中的数据存储
     * key：step.name
     * value: 来自this.data的加工后产出
     */
    private Map<String, Object> stepDataCollection;

    /**
     * 机制变量有点特殊，单独存储，每个机制变量都会是一个值，
     * 并且是可以重复读的，其操作行为与stepDataCollection是不同的，由不同的方法维护
     */
    private Map<String, Object> mechanismDataCollection;

    public Map<String, Object> getCommonVarCollection() {
        return commonVarCollection;
    }

    public void setCommonVarCollection(Map<String, Object> commonVarCollection) {
        this.commonVarCollection = commonVarCollection;
    }

    /**
     * 数据流、二次计算中新增的机制变量
     * /restful/service/knowledgegraph/Mechanism/querySmartDataVariable获取
     * numberRange中需要处理
     */
    private Map<String, Object> commonVarCollection;

    /**
     * 最终生成的data数据
     */
    private Object resultData;

    /**
     * 发现在join时，例如leftJoin，右表没有数据。
     * 这时不应该无法Join，而是按照右表字段进行Join出空字符串
     * 所以需要传入元数据描述右表，这里记录了元数据结构，该元数据同ActionsMetadata中解析的元数据结构
     * 处理时应该避免上来解析，而是当Join用到从属数据为空时才需要解析。
     */
    private Object joinMeta;

    /**
     * trans接收到的原始数据
     */
    private Object originData;
    private String tenantId;
    private String loginUserName;
    private String userId;
    private Map<String, Object> eocMap;

    /**
     * 日期转换 输入的日期类型。只分析第一笔数据的格式，后续的数据均使用该日期格式
     */
    private String inputFormat;

    private String outputFormat;

    public TransDataManger(JSONObject ruleJsonObj, Map<String, Object> originData, String tenantId, Map<String, Object> eocMap, String token) {
        this.ruleJsonObj = ruleJsonObj;
        this.originData = originData;
        this.tenantId = tenantId;
        this.eocMap = eocMap;
        this.token = token;
        this.stepDataCollection = new HashMap<>();
        this.mechanismDataCollection = new HashMap<>();
    }

    public String getInputFormat() {
        return inputFormat;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    public String getOutputFormat() {
        return outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public TransDataManger(JSONObject ruleJsonObj, Object originData, String tenantId) {
        this.ruleJsonObj = ruleJsonObj;
        this.originData = originData;
        this.tenantId = tenantId;
        this.stepDataCollection = new HashMap<>();
        this.mechanismDataCollection = new HashMap<>();
    }

    public TransDataManger(JSONObject ruleJsonObj, Object originData, String tenantId, Object joinMeta) {
        this.ruleJsonObj = ruleJsonObj;
        this.originData = originData;
        this.tenantId = tenantId;
        this.joinMeta = joinMeta;
        this.stepDataCollection = new HashMap<>();
        this.mechanismDataCollection = new HashMap<>();
    }

    public TransDataManger(JSONObject ruleJsonObj, Object originData, String tenantId, Map<String, Object> eocMap) {
        this.ruleJsonObj = ruleJsonObj;
        this.originData = originData;
        this.tenantId = tenantId;
        this.eocMap = eocMap;
        this.stepDataCollection = new HashMap<>();
        this.mechanismDataCollection = new HashMap<>();
    }

    public TransDataManger(JSONObject ruleJsonObj, Object originData, String tenantId, Map<String, Object> eocMap,String token) {
        this.ruleJsonObj = ruleJsonObj;
        this.originData = originData;
        this.tenantId = tenantId;
        this.eocMap = eocMap;
        this.token = token;
        this.stepDataCollection = new HashMap<>();
        this.mechanismDataCollection = new HashMap<>();
    }

    public Map<String, Object> getEocMap() {
        return eocMap;
    }

    public Object getStepDataCollection() {
        return stepDataCollection;
    }

    public Object getStepDataCollection(String stepName) {
        return stepDataCollection.get(stepName);
    }

    public void setStepDataCollection(String name, Object data) {
        this.stepDataCollection.put(name, data);
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public Object getJoinMeta() {
        return joinMeta;
    }

    public void setJoinMeta(Object joinMeta) {
        this.joinMeta = joinMeta;
    }

    public Object getOriginData() {
        return originData;
    }

    public void setOriginData(Object originData) {
        this.originData = originData;
    }

    public Object getResultData() {
        return resultData;
    }

    /**
     * 保存最终结果
     *
     * @param resultData
     */
    public void setResultData(Object resultData) {
        this.resultData = resultData;
    }

    public Object getCurrentData(String name) {
        return stepDataCollection.get(name);
    }

    public Object getCurrentDataAsList(String name) {
        return stepDataCollection.get(name);
    }

    /**
     * 保存当前执行结果到执行列表中，其实这里只是增加一个节点的执行记录，stepDataCollection.value都是data的引用
     *
     * @param name 产生结果的step的name
     * @param data
     * @return
     */
    public Object setCurrentData(String name, Object data) {
        return stepDataCollection.put(name, data);
    }

    /**
     * 根据name找到数据并clone一个新数据出来
     *
     * @param name
     * @return
     */
    public Object cloneCurrentData(String name) {
        return CloneUtil.clone(stepDataCollection.get(name));
    }

    /**
     * 读取机制变量集合
     *
     * @return
     */
    public Map<String, Object> getMechanismDataCollection() {
        return mechanismDataCollection;
    }

    /**
     * 根据机制变量名 读取机制变量
     *
     * @param varName
     * @return
     */
    public Object getMechanismData(String varName) {
        return mechanismDataCollection.get(varName);
    }

    /**
     * 保存机制变量
     *
     * @param mechanismDataCollection
     */
    public void setMechanismDataCollection(Map<String, Object> mechanismDataCollection) {
        this.mechanismDataCollection = mechanismDataCollection;
    }

    /**
     * 保存机制变量
     *
     * @param mechanismData
     */
    public void setMechanismData(Map<String, Object> mechanismData) {
        this.mechanismDataCollection.putAll(mechanismData);
    }

    public JSONObject getRuleJsonObj() {
        return ruleJsonObj;
    }

    public void setRuleJsonObj(JSONObject ruleJsonObj) {
        this.ruleJsonObj = ruleJsonObj;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getLoginUserName() {
        return loginUserName;
    }

    public void setLoginUserName(String loginUserName) {
        this.loginUserName = loginUserName;
    }
}
