/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.core.aop;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.container.exceptions.IDWException;
import com.digiwin.app.service.DWServiceChainContext;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ExceptionHandlerAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionHandlerAspect.class);
    private static final String SUBSTRING = "trace info: me: ";

    @Pointcut(value="@within(com.digiwin.athena.executionengine.core.aop.MyExceptionHandler)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        try {
            return proceedingJoinPoint.proceed();
        }
        catch (Exception e) {
            String chainInfo = DWServiceChainContext.getContext().getTraceElement().getTraceInfo(true);
            LOGGER.info("error  pinpoint transactionId:{} ", (Object)ThreadContext.get((String)"PtxId"));
            if (chainInfo.indexOf(SUBSTRING) != -1) {
                chainInfo = StringUtils.substringAfter((String)chainInfo, (String)SUBSTRING);
            }
            if (e instanceof IDWException) {
                IDWException exception = (IDWException)e;
                if (!exception.getInstructors().containsKey("chainInfo") || exception.getInstructors().get("chainInfo") == null) {
                    exception.getInstructors().put("chainInfo", chainInfo);
                }
                if (!exception.getInstructors().containsKey("PtxId") || exception.getInstructors().get("PtxId") == null) {
                    exception.getInstructors().put("PtxId", ThreadContext.get((String)"PtxId"));
                }
                exception.getInstructors().put("serverTime", System.currentTimeMillis());
                throw e;
            }
            LOGGER.error("\u975eIDWException\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            DWRuntimeException exception = new DWRuntimeException(ErrorCodeEnum.UNKNOWN_EXCEPTION.getCode(), e.getMessage());
            exception.getInstructors().put("chainInfo", chainInfo);
            exception.getInstructors().put("PtxId", ThreadContext.get((String)"PtxId"));
            exception.getInstructors().put("serverTime", System.currentTimeMillis());
            throw exception;
        }
    }
}

