package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.constant.MetaDataConstant;
import com.digiwin.athena.executionengine.constant.TransConstant;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.repository.dao.EngineAllViewMapper;
import com.digiwin.athena.executionengine.repository.model.MysqlAllViewEntity;
import com.digiwin.athena.executionengine.util.DateUtils;
import com.digiwin.athena.executionengine.util.JsonUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @description:
 * @author:
 * @date:
 */
@Service("BMD")
public class BMD extends ActionBase{
    private static final Logger LOGGER = LoggerFactory.getLogger(BMD.class);
    private static final String DIGI_MIDDLEWARE_AUTH_USER = "digi-middleware-auth-user";
    private static final String RESPONSE_CODE = "code";
    private static final String METHOD = "POST";

    @Autowired
    private EngineAllViewMapper allViewMapper;

    @Override
    public Object actionExecute(ExecuteContext context, Map<String, Object> reqData, ActionParam actionParam) {
        Object object = new Object();
        try {

            String actionId = actionParam.getActionId();
            JSONObject metaObj = actionParam.getMetaObj();
            //获取元数据中定义的 request结构
            JSONObject requestObj = metaObj.getJSONObject(MetaDataConstant.METADATAS_ACTION_REQUEST);
            //获取request结构中的parameters结构
            JSONArray parameters = requestObj.getJSONArray(MetaDataConstant.METADATAS_ACTION_REQUEST_PARAMETERS);
            LinkedHashMap newReqData = new LinkedHashMap<>(4);
            for (int i = 0; i < parameters.size(); i++) {
                JSONObject param = parameters.getJSONObject(i);
                if(TransConstant.STATISTIC_TYPE_DATE.equals(param.get(MetaDataConstant.METADATAS_PARAM_DATA_TYPE))){
                    //如果是时间字段，则通过"#"进行分割为开始时间和结束时间：例如：2021-01-01#2021-12-31
                    String time = (String) reqData.get(param.getString(MetaDataConstant.METADATAS_PARAM_DATA_NAME));
                    if(StringUtils.isBlank(time)){
                        newReqData.put("start_time", DateUtils.getfirstDayOfLastMonth(""));
                        newReqData.put("end_time", DateUtils.getLastDayOfLastMonth(""));
                    }else {
                        String[] times = time.split("#");
                        newReqData.put("start_time", times[0]);
                        newReqData.put("end_time", times[1]);
                    }
                    //reqData.remove(param.getString(MetaDataConstant.METADATAS_PARAM_DATA_NAME));
                }else {
                    newReqData.put(param.getString(MetaDataConstant.METADATAS_PARAM_DATA_NAME),
                            reqData.get(param.getString(MetaDataConstant.METADATAS_PARAM_DATA_NAME)));
                }
            }
            //34个了
            if("BMD_S00010".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00010(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00011".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00011(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00012".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00012(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00013".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00013(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00014".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00014(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00015".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00015(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00020".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00020(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00030".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00030(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00040".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00040(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00040-1".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00040_1(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00041".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00041(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00050".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00050(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00060".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00060(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00061".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00061(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00062".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00062(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00063".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00063(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00064".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00064(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00070".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00070(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00072".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00072(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00080".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00080(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00090".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00090(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00091".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00091(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00092".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00092(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00095".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00095(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00096".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00096(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00097".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00097(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00100".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00100(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00110".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00110(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00120".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00120(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00130".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00130(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00140".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00140(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00150".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00150(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00160".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00160(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00170".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00170(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00171".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00171(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00172".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00172(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00180".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00180(newReqData)),
                        MysqlAllViewEntity.class);
            }else if("BMD_S00210".equals(actionId)){
                object = JsonUtil.getList(
                        JsonUtil.getJsonString(allViewMapper.getS00210(newReqData)),
                        MysqlAllViewEntity.class);
            }else {

            }

        } catch (Exception e) {
        context.setExecuteStatus(false);
        LOGGER.error("直接查数据", e);
        throw e;
    }
        return object;
    }

}
