package com.digiwin.athena.executionengine.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * @description: 获取ip地址工具类
 * @author: dongwh
 * @date: 2020/8/20 15:54
 */
public class IpUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpUtils.class);

    public static String getIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        } catch (UnknownHostException e) {
            LOGGER.error("获取IP失败：", e);
            return "127.0.0.1";
        }
    }
}
