package com.digiwin.athena.executionengine.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2021/9/7
 */
public class ThreadPoolUtils {
    /**
     * 自定义线程名
     **/
    private static final ThreadFactory threadFactory = new ThreadFactoryBuilder()
            .setNameFormat("ExecutionEngine-%d")
            .setDaemon(true)
            .build();

    /**
     * 等待队列容量
     */
    private static final int QUEUE_SIZE = 2000;

    private static final ExecutorService EXECUTOR_SERVICE = new ThreadPoolExecutor(100,
            500,
            60L, TimeUnit.SECONDS,
            new LinkedBlockingQueue<>(QUEUE_SIZE), threadFactory);

    public static ExecutorService getExecutorService() {
        return EXECUTOR_SERVICE;
    }

}
