/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.component.param;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.model.ParamElement;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingManager;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class ParamBase {
    String name;
    String value;
    String valJsonPath;
    String valParamPath;
    JSONArray except;

    public void initInstance(JSONObject paramObj) {
        this.name = paramObj.getString("name");
        this.value = paramObj.getString("value");
        this.except = paramObj.getJSONArray("except");
        this.initProperty(paramObj);
    }

    protected abstract void initProperty(JSONObject var1);

    protected abstract boolean eval(ExecuteContext var1);

    public boolean parEvalAndExclude(ExecuteContext context) {
        return this.eval(context);
    }

    public abstract String getSrcActionId(ExecuteContext var1);

    public abstract Object getData(ExecuteContext var1, String var2);

    public abstract Object getData(ExecuteContext var1, DataMappingManager var2, String var3, String var4) throws Exception;

    public abstract int getDataSize(DataMappingManager var1, String var2, String var3, String var4);

    public abstract int getRootSize(DataMappingManager var1, String var2);

    public abstract List<String> getCollectionPath(DataMappingManager var1, String var2, String var3);

    public abstract boolean isCollectionRoot(DataMappingManager var1, String var2);

    public abstract boolean isCollectionParam(DataMappingManager var1, String var2, String var3);

    public abstract boolean isObjectCollectionParam(DataMappingManager var1, String var2, String var3);

    public abstract int countCollectionInPath(DataMappingManager var1, String var2, String var3);

    public abstract int getPathDataSize(DataMappingManager var1, String var2, String var3, String var4);

    public abstract int getPathDataSize(DataMappingManager var1, String var2, String var3);

    public abstract boolean pathIsExistsInData(DataMappingManager var1, String var2, String var3);

    private Object exclude(Object val, ExecuteContext context) {
        if (null == val || CollectionUtils.isEmpty((Collection)this.except)) {
            return val;
        }
        boolean isArray = false;
        String jsonPathPrefix = "$";
        if (val instanceof List) {
            isArray = true;
            jsonPathPrefix = "$[*].";
        }
        String valJson = JSON.toJSONString((Object)val);
        String elementPathPrefix = StringUtils.replace((String)this.valParamPath, (String)this.value, (String)"");
        for (int i = 0; i < this.except.size(); ++i) {
            ParamElement paramElement = context.getParamElement(elementPathPrefix + this.except.getString(i));
            if (null == paramElement) continue;
            String path = StringUtils.replace((String)paramElement.getElementJsonPath(), (String)this.valJsonPath, (String)jsonPathPrefix);
            valJson = JsonPath.parse((String)valJson).delete(path, new Predicate[0]).jsonString();
        }
        if (isArray) {
            return JSONArray.parse((String)valJson);
        }
        return JSONObject.parse((String)valJson);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public abstract void setParentPathPos(DataMappingManager var1, String var2, String var3, int var4);

    public abstract void setPathPos(DataMappingManager var1, String var2, String var3, int var4);

    public abstract String getDataJsonPath(DataMappingManager var1, String var2, String var3);
}

