package com.digiwin.athena.executionengine.exception;

import com.digiwin.app.container.exceptions.DWRuntimeException;

/**
 * @description: 执行引擎规则校验异常类
 * @author: zhangww
 * @date: 2021/2/19 15:23
 */
public class VerificationException extends DWRuntimeException {

    @Override
    public String getErrorType() {
        return "application";
    }

    /**
     * 构造一个基本异常.
     *
     * @param message 信息描述
     */
    public VerificationException(String message) {
        super(message);
    }

    /**
     * 构造一个基本异常.
     *
     * @param errorCode 错误编码
     * @param message   信息描述
     */
    public VerificationException(String errorCode, String message) {
        super(errorCode,message);
    }


    /**
     * 构造一个基本异常.
     *
     * @param errorCode 错误编码
     * @param message   信息描述
     */
    public VerificationException(String errorCode, String message, Throwable cause) {
        super(message, cause);
    }

    public VerificationException(String errorCode, String message, String... messageArgs) {
        super(errorCode, message, messageArgs);
    }


    /**
     * 构造一个基本异常.
     *
     * @param message 信息描述
     * @param cause   根异常类（可以存入任何异常）
     */
    public VerificationException(String message, Throwable cause) {
        super(message, cause);
    }

}
