/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.data.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.bo.DataCenterParamBo;
import com.digiwin.athena.executionengine.core.container.SolutionStepContext;
import com.digiwin.athena.executionengine.dto.DataCenterDto;
import com.digiwin.athena.executionengine.model.DataDescription;
import com.digiwin.athena.executionengine.model.solutionStep.SolutionStepMetric;
import com.digiwin.athena.executionengine.service.client.IDataCenterClient;
import com.digiwin.athena.executionengine.service.facade.data.IScraper;
import com.digiwin.athena.executionengine.service.facade.schema.ISchemaBuilder;
import com.digiwin.athena.executionengine.vo.MetricResultVo;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="dataset")
public class DatasetScraper
implements IScraper {
    @Autowired
    private ISchemaBuilder schemaBuilder;
    @Autowired
    private IDataCenterClient dataCenterClient;

    @Override
    public MetricResultVo fetchData(SolutionStepMetric metric, SolutionStepContext context) {
        DataDescription dataDescription = new DataDescription();
        JSONObject dynamicSchema = new JSONObject();
        dynamicSchema.put("groupBy", CollectionUtils.isEmpty(metric.getGroupBy()) ? null : JSONArray.parseArray((String)JSONArray.toJSONString(metric.getGroupBy())));
        dynamicSchema.put("filter", metric.getFilter() == null || CollectionUtils.isEmpty(metric.getFilter().getChildren()) ? null : JSONObject.parseObject((String)JSONObject.toJSONString((Object)metric.getFilter())));
        dynamicSchema.put("having", metric.getHaving() == null || CollectionUtils.isEmpty(metric.getHaving().getChildren()) ? null : JSONObject.parseObject((String)JSONObject.toJSONString((Object)metric.getHaving())));
        dynamicSchema.put("computeList", metric.getComputeList() == null || metric.getComputeList().isEmpty() ? null : metric.getComputeList());
        dynamicSchema.put("sort", CollectionUtils.isEmpty(metric.getSort()) ? null : JSONArray.parseArray((String)JSONObject.toJSONString(metric.getSort())));
        dynamicSchema.put("select", (Object)JSONArray.parseArray((String)JSONObject.toJSONString(metric.getSelect())));
        dynamicSchema.put("fieldMapping", (Object)context.getDatasetFieldsMapping().get(metric.getMetric()));
        dataDescription.setDynamicSchema(dynamicSchema);
        dataDescription.setDatasetPermissions(this.getRow(context.getPermissions()));
        DataCenterParamBo dataCenterParamBo = this.schemaBuilder.buildDataCenterSchema(dataDescription);
        JSONArray dataCenterData = this.dataCenterClient.getDataCenterData(this.buildDataCenterParam(metric, context, dataCenterParamBo));
        JSONObject data = new JSONObject();
        data.put("data", (Object)dataCenterData);
        return new MetricResultVo(data, null);
    }

    private JSONArray getRow(Map<String, Object> permissions) {
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString(permissions));
        if (jsonObject.containsKey((Object)"rows") && !CollectionUtils.isEmpty((Collection)jsonObject.getJSONArray("rows"))) {
            return jsonObject.getJSONArray("rows");
        }
        return null;
    }

    private DataCenterDto buildDataCenterParam(SolutionStepMetric metric, SolutionStepContext context, DataCenterParamBo dataCenterParamBo) {
        DataCenterDto dataCenterDto = new DataCenterDto();
        dataCenterDto.setPageSize(10000);
        dataCenterDto.setPageNo(1);
        dataCenterDto.setQuerySchema(dataCenterParamBo.getQuerySchema());
        dataCenterDto.setOrderColumn(CollectionUtils.isEmpty((Collection)dataCenterParamBo.getOrderColumn()) ? null : dataCenterParamBo.getOrderColumn());
        dataCenterDto.setModelId(metric.getModelId());
        dataCenterDto.setModelCode(metric.getModelCode());
        dataCenterDto.setToken(context.getToken());
        dataCenterDto.setRouterKey(context.getTenantId());
        return dataCenterDto;
    }
}

