/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.schema.datacenter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.CommonConstant;
import com.digiwin.athena.executionengine.dto.schema.DateFormatDto;
import com.digiwin.athena.executionengine.dto.schema.SchemaTransDto;
import com.digiwin.athena.executionengine.service.facade.schema.AbstractSchemaConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class DataCenterGroupConvertor
extends AbstractSchemaConvertor {
    @Override
    public void convert(SchemaTransDto schemaTransDto) {
        JSONObject querySchema = schemaTransDto.getQuerySchema();
        Object dynamicSchema = schemaTransDto.getDynamicSchema();
        if (dynamicSchema == null) {
            return;
        }
        JSONArray groups = (JSONArray)dynamicSchema;
        if (CollectionUtils.isEmpty((Collection)groups)) {
            return;
        }
        JSONObject mappingFields = (JSONObject)schemaTransDto.getReqData();
        List<JSONObject> exclusionCalNodes = groups.stream().map(o -> (JSONObject)o).filter(item -> !"calculate".equals(item.getString("contentType"))).collect(Collectors.toList());
        this.handleGroup(querySchema, exclusionCalNodes, mappingFields);
        List<JSONObject> calculateObj = groups.stream().map(o -> (JSONObject)o).filter(item -> "calculate".equals(item.getString("contentType"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(calculateObj)) {
            return;
        }
        JSONObject computeObj = schemaTransDto.getComputeObj();
        ArrayList dateFormatDtos = new ArrayList();
        calculateObj.forEach(item -> {
            String content = item.getString("content");
            JSONArray computeList = computeObj.getJSONArray(content);
            if (CollectionUtils.isEmpty((Collection)computeList)) {
                return;
            }
            computeList.forEach(o -> {
                JSONObject computeItem = (JSONObject)o;
                String calFunction = computeItem.getString("calFunction");
                if ("DateFormat".equals(calFunction)) {
                    JSONArray params = computeItem.getJSONArray("params");
                    JSONObject fieldParam = params.getJSONObject(0);
                    JSONObject formatParam = params.getJSONObject(1);
                    String field = fieldParam.getString("content");
                    String fieldType = fieldParam.getString("dataType");
                    String format = formatParam.getString("content");
                    DateFormatDto dateFormatDto = new DateFormatDto(field, CommonConstant.DATA_CENTER_FUNCTION_MAP.get(format));
                    dateFormatDto.setFieldType(fieldType);
                    dateFormatDtos.add(dateFormatDto);
                }
            });
        });
        if (CollectionUtils.isNotEmpty(dateFormatDtos)) {
            dateFormatDtos.forEach(dateFormatDto -> {
                JSONObject computeObject = new JSONObject();
                computeObject.put("field", (Object)dateFormatDto.getField());
                computeObject.put("dataType", (Object)dateFormatDto.getFieldType().toUpperCase());
                computeObject.put("expression", (Object)("date_format([" + mappingFields.getString(dateFormatDto.getField()) + "],'" + dateFormatDto.getFormat() + "')"));
                querySchema.getJSONArray("computedFields").add((Object)computeObject);
                JSONObject groupObject = new JSONObject();
                groupObject.put("field", (Object)dateFormatDto.getField());
                groupObject.put("name", (Object)dateFormatDto.getField());
                groupObject.put("dataType", (Object)dateFormatDto.getFieldType().toUpperCase());
                if (!this.dimensionsIsExist(querySchema, dateFormatDto.getField())) {
                    querySchema.getJSONArray("dimensions").add((Object)groupObject);
                }
            });
        }
    }

    private void handleGroup(JSONObject querySchema, List<JSONObject> exclusionCalNodes, JSONObject mappingFields) {
        exclusionCalNodes.forEach(obj -> {
            String dataType = obj.getString("dataType");
            String content = obj.getString("content");
            JSONObject groupObject = new JSONObject();
            groupObject.put("field", (Object)mappingFields.getString(content));
            groupObject.put("name", (Object)content);
            groupObject.put("dataType", (Object)dataType.toUpperCase());
            if (!this.dimensionsIsExist(querySchema, content)) {
                querySchema.getJSONArray("dimensions").add((Object)groupObject);
            }
        });
    }
}

