package com.digiwin.athena.executionengine.component.domain;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.param.ParamBase;
import com.digiwin.athena.executionengine.constant.ResultStatusConstant;
import com.digiwin.athena.executionengine.model.ParamElement;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2022/8/26
 */
public class ActionParam {
    /**
     * actionId
     */
    private String actionId;

    /**
     * actionType
     */
    private String actionType;

    /**
     * actionName
     */
    private String actionName;
    /**
     * metaData json对象
     */
    private JSONObject metaObj;
    private List<ParamElement> apiMeta;

    private JSONObject standardParameterMapping;

    /**
     * 维度+度量==设计器配置的
     */
    private JSONObject aggregation;

    public JSONObject getAggregation() {
        return aggregation;
    }

    public void setAggregation(JSONObject aggregation) {
        this.aggregation = aggregation;
    }

    public JSONObject getStandardParameterMapping() {
        return standardParameterMapping;
    }

    public void setStandardParameterMapping(JSONObject standardParameterMapping) {
        this.standardParameterMapping = standardParameterMapping;
    }

    public ActionParam(String actionId, String actionName, String actionType, JSONObject metaObj) {
        this.actionId = actionId;
        this.actionName = actionName;
        this.metaObj = metaObj;
        this.actionType = actionType;
    }

    /**
     * actions json对象
     */
    private JSONObject actionJson;

    /**
     * action依赖的paramBase集合
     */
    private List<ParamBase> params = new ArrayList<>();
    /**
     * action入参元数据对象
     */
    private List<ParamElement> requestParams = new ArrayList<>();
    /**
     * action定义是否需要foreach
     */
    private boolean isForeach;
    /**
     * microTrans的定义
     */
    private JSONObject microTrans;

    /**
     * action状态 -1  执行失败，0 未执行，1 执行成功
     */
    private volatile int actionState = ResultStatusConstant.UN_EXECUTED.getCode();

    private JSONObject querySchema;


    public String getActionId() {
        return actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public String getActionName() {
        return actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public JSONObject getMetaObj() {
        return metaObj;
    }

    public void setMetaObj(JSONObject metaObj) {
        this.metaObj = metaObj;
    }

    public JSONObject getActionJson() {
        return actionJson;
    }

    public void setActionJson(JSONObject actionJson) {
        this.actionJson = actionJson;
    }

    public List<ParamBase> getParams() {
        return params;
    }

    public void setParams(List<ParamBase> params) {
        this.params = params;
    }

    public List<ParamElement> getRequestParams() {
        return requestParams;
    }

    public void setRequestParams(List<ParamElement> requestParams) {
        this.requestParams = requestParams;
    }

    public boolean isForeach() {
        return isForeach;
    }

    public void setForeach(boolean foreach) {
        isForeach = foreach;
    }

    public int getActionState() {
        return actionState;
    }

    public void setActionState(int actionState) {
        this.actionState = actionState;
    }

    public JSONObject getMicroTrans() {
        return this.microTrans;
    }

    public void setMicroTrans(JSONObject microTrans) {
        this.microTrans = microTrans;
    }

    public JSONObject getQuerySchema() {
        return this.querySchema;
    }

    public void setQuerySchema(JSONObject querySchema) {
        this.querySchema = querySchema;
    }

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public void setApiMeta(List<ParamElement> apiMeta) {
        this.apiMeta = apiMeta;
    }

    public List<ParamElement> getApiMeta() {
        return apiMeta;
    }
}
