package com.digiwin.athena.executionengine.component.param;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.MetaDataConstant;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingManager;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * @description:
 * @author: renwm
 * @date: 2020/6/15 9:32
 */
public class CaseParam extends ParamBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaseParam.class);

    private ParamBase caseInput;
    private List<CaseBranch> caseBranches;
    /**
     * 最终选择的thenParam
     */
    private ParamBase eligibleThen;

    public CaseParam() {
        caseBranches = Lists.newArrayList();
    }

    /**
     * 每个CaseBranch节点
     */
    private class CaseBranch {
        private ParamBase whenParam;
        private ParamBase thenParam;

        public CaseBranch(ParamBase whenParam, ParamBase thenParam) {
            this.whenParam = whenParam;
            this.thenParam = thenParam;
        }
    }

    @Override
    protected void initProperty(JSONObject paramObj) {
        caseInput = Optional.ofNullable(paramObj.getJSONObject(MetaDataConstant.ACTIONS_PARAMS_CASE_INPUT))
                .map(obj -> ParamFactory.createParam(obj))
                .orElse(null);
        if (caseInput == null) {
            return;
        }
        caseInput.name = this.name;
        JSONArray branches = paramObj.getJSONArray(MetaDataConstant.ACTIONS_PARAMS_CASE_BRANCHES);
        if (CollectionUtils.isEmpty(branches)) {
            return;
        }
        for (int i = 0, len = branches.size(); i < len; i++) {
            JSONObject caseBranchObj = branches.getJSONObject(i);
            ParamBase whenParam = ParamFactory.createParam(caseBranchObj.getJSONObject(MetaDataConstant.ACTIONS_PARAMS_CASE_BRANCHES_WHEN));
            ParamBase thenParam = ParamFactory.createParam(caseBranchObj.getJSONObject(MetaDataConstant.ACTIONS_PARAMS_CASE_BRANCHES_THEN));
            if (whenParam == null || thenParam == null) {
                continue;
            }
            whenParam.name = this.name;
            thenParam.name = this.name;
            caseBranches.add(new CaseBranch(whenParam, thenParam));
        }
    }

    @Override
    public boolean eval(ExecuteContext context) {
        if (!doEval(caseInput, context)) {
            LOGGER.error("caseInput eval 失败,CaseParam执行失败");
            return false;
        }
        Object inputVal = getDataByTemplatePath(context, caseInput);
        LOGGER.info("caseInput取到的值:{}", inputVal);

        for (CaseBranch branchParam : caseBranches) {
            if (!doEval(branchParam.whenParam, context)) {
                LOGGER.error("whenParam eval失败,即将continue下一个whenParam");
                continue;
            }
            Object whenVal = getDataByTemplatePath(context, branchParam.whenParam);
            LOGGER.info("whenVal取到的值:{}", whenVal);

            if (Objects.equals(inputVal, whenVal)) {
                eligibleThen = branchParam.thenParam;
                this.value = eligibleThen.getValue();
                return branchParam.thenParam.eval(context);
            }
        }
        LOGGER.warn("没有匹配的casewhen条件");
        return false;
    }

    /**
     * paramBase eval值，增加异常捕获，打印异常信息
     *
     * @param paramBase
     * @param context
     * @return
     */
    private boolean doEval(ParamBase paramBase, ExecuteContext context) {
        try {
            if (paramBase.eval(context)) {
                return true;
            }
        } catch (Exception e) {
            LOGGER.error("paramBase eval 异常", e);
        }
        return false;
    }

    /**
     * 根据dataNode中的templatePath 获取数据
     *
     * @param context
     * @param paramBase
     * @return
     * @throws Exception
     */
    private Object getDataByTemplatePath(ExecuteContext context, ParamBase paramBase) {
        String templatePath = context.getDataMappingManager().getDatMappingHandler(context.getInputParam().getActionId(),
                paramBase.getSrcActionId(context)).getPathTemplateByPath(paramBase.getValue());
        return paramBase.getData(context, templatePath);
    }


    /**
     * 这里可能还有些问题，目前看caseInput可能会有多个值，如果有多个，那么就要指定一个具体的jsonpath来取
     * 但是理论上case条件应该是只有一个具体的值。所以只要传一个具体的jsonpath就可以了，
     * 这样就可以拿到then的结果的来自的actionid
     *
     * @param context
     * @return
     * @throws Exception
     */
    @Override
    public String getSrcActionId(ExecuteContext context) {
        return eligibleThen.getSrcActionId(context);
    }

    /**
     * 2020-11-17 重构入参结构的时候，复杂度过高 < 以下所有方法 >
     * 思考： 对于case的取值，实际上是用caseInput.value，通过一些列判断以后，换取得到then.value的值
     * 思考： 所以现在相当于，给caseInput.value的jsonPath，那么通过一系列判断以后，换取到then.value的值
     *
     * @param context
     * @param jsonPath
     * @return
     */
    @Override
    public Object getData(ExecuteContext context, String jsonPath) {
        return eligibleThen.getData(context, jsonPath);
    }

    @Override
    public Object getData(ExecuteContext context, DataMappingManager dataMappingManager, String requestActionId, String paramPath) throws Exception {
        return eligibleThen.getData(context, dataMappingManager, requestActionId, paramPath);
    }

    @Override
    public int getDataSize(DataMappingManager dataMappingManager, String requestActionId, String paramPath, String jsonPath) {
        return eligibleThen.getDataSize(dataMappingManager, requestActionId, paramPath, jsonPath);
    }

    @Override
    public int getRootSize(DataMappingManager dataMappingManager, String requestActionId) {
        return eligibleThen.getRootSize(dataMappingManager, requestActionId);
    }

    @Override
    public boolean isCollectionRoot(DataMappingManager dataMappingManager, String requestActionId) {
        return eligibleThen.isCollectionRoot(dataMappingManager, requestActionId);
    }

    @Override
    public boolean isCollectionParam(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return eligibleThen.isCollectionParam(dataMappingManager, requestActionId, paramPath);
    }

    @Override
    public boolean isObjectCollectionParam(DataMappingManager dataMappingManager, String requestActionId, String param) {
        return eligibleThen.isObjectCollectionParam(dataMappingManager, requestActionId, param);
    }

    @Override
    public List<String> getCollectionPath(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return eligibleThen.getCollectionPath(dataMappingManager, requestActionId, paramPath);
    }

    @Override
    public int getPathDataSize(DataMappingManager dataMappingManager, String requestActionId, String paramPath, String fixedPath) {
        return eligibleThen.getPathDataSize(dataMappingManager, requestActionId, paramPath, fixedPath);
    }

    /**
     * 根据paramPath，获取上一级节点的实际路径作为限定范围路径，取该范围路径下的数据量
     *
     * @param dataMappingManager
     * @param requestActionId
     * @param paramPath
     * @return
     */
    @Override
    public int getPathDataSize(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return eligibleThen.getPathDataSize(dataMappingManager, requestActionId, paramPath);
    }

    @Override
    public boolean pathIsExistsInData(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return eligibleThen.pathIsExistsInData(dataMappingManager, requestActionId, paramPath);
    }

    @Override
    public int countCollectionInPath(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return eligibleThen.countCollectionInPath(dataMappingManager, requestActionId, paramPath);
    }

    /**
     * 通过参数映射关系设置数据的实际下标
     *
     * @param paramPath
     * @param pos
     */
    @Override
    public void setParentPathPos(DataMappingManager dataMappingManager, String requestActionId, String paramPath, int pos) {
        eligibleThen.setParentPathPos(dataMappingManager, requestActionId, paramPath, pos);
    }

    /**
     * 通过参数映射关系获取数据的实际下标
     *
     * @param paramPath
     */
    @Override
    public void setPathPos(DataMappingManager dataMappingManager, String requestActionId, String paramPath, int pos) {
        eligibleThen.setPathPos(dataMappingManager, requestActionId, paramPath, pos);
    }

    /**
     * 通过参数映射关系获取数据的真实的JsonPath
     *
     * @param paramPath
     */
    @Override
    public String getDataJsonPath(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return eligibleThen.getDataJsonPath(dataMappingManager, requestActionId, paramPath);
    }


}
