package com.digiwin.athena.executionengine.component.param;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.MetaDataConstant;
import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingHandler;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingManager;
import com.digiwin.athena.executionengine.util.ContextUtils;
import com.digiwin.athena.executionengine.util.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Optional;

/**
 * @description:
 * @author: renwm
 * @date: 2020/6/15 9:32
 */
public class PullingParam extends ParamBase {

    private String source;

    public String getSource() {
        return source;
    }

    @Override
    protected void initProperty(JSONObject paramObj) {
        this.source = paramObj.getString(MetaDataConstant.ACTIONS_PARAMS_SOURCE);
    }

    @Override
    public boolean eval(ExecuteContext context) {
        if (StringUtils.isBlank(source)) {
            return false;
        }

        ActionBase actionBase = Optional.ofNullable(context.getActionParam(source)).map(ap ->
                ContextUtils.getBean(ap.getActionName(), ActionBase.class)).orElse(null);
        if (null == actionBase) {
            throw ExceptionUtils.buildBusinessException(ErrorCodeEnum.ACTION_NOT_FOUND, source);
        }

        ////用于runinfo的打印显示层级
        context.pullLevel++;
        actionBase.prepare(context, context.getActionParam(source));
        ////用于runinfo的打印显示层级
        context.pullLevel--;
        return true;
    }

    @Override
    public boolean isCollectionRoot(DataMappingManager dataMappingManager, String requestActionId) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, source);
        return dataMappingHandler.isCollectionParam("$");
    }

    @Override
    public boolean isCollectionParam(DataMappingManager dataMappingManager, String requestActionId, String param) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, source);
        return dataMappingHandler.isCollectionParam(param);
    }

    @Override
    public boolean isObjectCollectionParam(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, source);
        return dataMappingHandler.isObjectCollectionParam(paramPath);
    }

    @Override
    public int getPathDataSize(DataMappingManager dataMappingManager, String requestActionId, String paramPath, String fixedPath) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, source);
        return dataMappingHandler.getPathDataSize(paramPath, fixedPath);
    }

    /**
     * 根据paramPath，获取上一级节点的实际路径作为限定范围路径，取该范围路径下的数据量
     *
     * @param dataMappingManager
     * @param requestActionId
     * @param paramPath
     * @return
     */
    @Override
    public int getPathDataSize(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, source);
        return dataMappingHandler.getPathDataSize(paramPath);
    }

    @Override
    public boolean pathIsExistsInData(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, source);
        return dataMappingHandler.pathIsExistsInData(paramPath);
    }

    /**
     * 返回这个数据所在actionid
     *
     * @param context
     * @return
     */
    @Override
    public String getSrcActionId(ExecuteContext context) {
        return source;
    }

    @Override
    public Object getData(ExecuteContext context, String jsonPath) {
        Object resp = context.getActionResponse(source);
        if (null == resp) {
            return null;
        }

        return context.getParamGetDataHandler().getData(source, resp, jsonPath);

    }

    @Override
    public Object getData(ExecuteContext context, DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, source);
        String jsonPath = dataMappingHandler.getConcreteJsonPath(paramPath);
        return getData(context, jsonPath);
    }

    @Override
    public int getDataSize(DataMappingManager dataMappingManager, String requestActionId, String paramPath, String jsonPath) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, source);
        return dataMappingHandler.getZoneDataSize(paramPath, jsonPath);
    }

    @Override
    public int getRootSize(DataMappingManager dataMappingManager, String requestActionId) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, source);
        return dataMappingHandler.getZoneDataSize("$", "");
    }

    @Override
    public List<String> getCollectionPath(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, source);
        return dataMappingHandler.getCollectionParamPathList(paramPath);
    }

    @Override
    public int countCollectionInPath(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, source);
        return dataMappingHandler.countCollectionInPath(paramPath);
    }

    /**
     * 通过参数映射关系设置数据的实际下标
     *
     * @param paramPath
     * @param pos
     */
    @Override
    public void setParentPathPos(DataMappingManager dataMappingManager, String requestActionId, String paramPath, int pos) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, source);
        dataMappingHandler.setParentNodePosition(paramPath, pos);
    }

    /**
     * 通过参数映射关系获取数据的实际下标
     *
     * @param paramPath
     */
    @Override
    public void setPathPos(DataMappingManager dataMappingManager, String requestActionId, String paramPath, int pos) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, source);
        dataMappingHandler.setNodePosition(paramPath, pos);
    }

    /**
     * 通过参数映射关系获取数据的真实的JsonPath
     *
     * @param paramPath
     */
    @Override
    public String getDataJsonPath(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, source);
        return dataMappingHandler.getDataJsonPath(paramPath);
    }

}
