package com.digiwin.athena.executionengine.core.container;

import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.constant.CommonConstant;
import com.digiwin.athena.executionengine.core.holder.ReadContextHolder;
import com.digiwin.athena.executionengine.dto.ErrorLog;
import com.digiwin.athena.executionengine.enumtype.ActionTypeEnum;
import com.digiwin.athena.executionengine.model.ParamElement;
import com.digiwin.athena.executionengine.model.input.InputParamModule;
import com.digiwin.athena.executionengine.service.facade.execution.asyc.ActionQueue;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingManager;
import com.google.common.collect.Lists;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @description: 执行引擎action执行的上下文对象
 * @author: renwm
 * @date: 2020/6/12 16:37
 */
public class ExecuteContext {

    Map<String, ActionParam> actionParamMap;
    Map<String, Object> actionResponseMap;
    Map<String, String> line = new HashMap<>();

    public Map<String, String> getLine() {
        return line;
    }

    Map<String, ParamElement> paramElementMap;
    InputParamModule inputParam;
    Set<String> inputParamKeys;
    Set<String> sysParamKeys;
    String token;
    String securityToken;
    String BMDtoken;
    private boolean executeStatus;
    private String currentActionId;
    private DataMappingManager dataMappingManager;
    private String locale;
    private RunInfo runInfo;
    private ReadContextHolder readContextHolder;

    private Map<String, Object> mockData;

    private ExecuteErrorMessage executeErrorMessage;

    public ExecuteErrorMessage getExecuteErrorMessage() {
        return executeErrorMessage;
    }

    public void setExecuteErrorMessage(ExecuteErrorMessage executeErrorMessage) {
        this.executeErrorMessage = executeErrorMessage;
    }

    public Map<String, Object> getMockData() {
        return mockData;
    }

    public ActionQueue actionQueue = new ActionQueue();

    public ActionQueue getActionQueue() {
        return actionQueue;
    }

    public int pullLevel;

    /**
     * 是否释放内存,默认释放
     */
    private boolean isRelease = true;

    public boolean isRelease() {
        return isRelease;
    }

    public void setRelease(boolean release) {
        isRelease = release;
    }

    private String routerKey;
    private String monitorProcessType;

    private long messageId;

    /**
     * 应用 code
     */
    private String application;

    /**
     * 作业类型
     * DATA_ENTRY-业务数据录入，TASK-任务，MONITOR_RULE-侦测
     */
    private String taskType;

    /**
     * 作业 code
     */
    private String taskCode;

    public long getMessageId() {
        return messageId;
    }

    public void setMessageId(long messageId) {
        this.messageId = messageId;
    }

    public String getMonitorProcessType() {
        return monitorProcessType;
    }

    public void setMonitorProcessType(String monitorProcessType) {
        this.monitorProcessType = monitorProcessType;
    }

    public String getRouterKey() {
        return routerKey;
    }

    public void setRouterKey(String routerKey) {
        this.routerKey = routerKey;
    }

    private ErrorLog errorLog;

    public ErrorLog getErrorLog() {
        return errorLog;
    }

    public void setErrorLog(ErrorLog errorLog) {
        this.errorLog = errorLog;
    }

    public String getSecurityToken() {
        return securityToken;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    /**
     * 根节点指标id
     */
    private String rootMetricId;
    /**
     * 查询
     */
    private Map<String, List<String>> querySqlMap = new HashMap<>();

    private boolean isDebug = false;

    public boolean isDebug() {
        return isDebug;
    }

    public void setDebug(boolean debug) {
        isDebug = debug;
    }

    public String getRootMetricId() {
        return rootMetricId;
    }

    public void setRootMetricId(String rootMetricId) {
        this.rootMetricId = rootMetricId;
    }

    public Map<String, List<String>> getQuerySqlMap() {
        return querySqlMap;
    }

    public void setQuerySqlMap(Map<String, List<String>> querySqlMap) {
        this.querySqlMap = querySqlMap;
    }

    public ExecuteContext() {
        actionParamMap = new HashMap<>();
        actionResponseMap = new ConcurrentHashMap<>();
        paramElementMap = new HashMap<>();
        inputParam = new InputParamModule();
        inputParamKeys = new HashSet<>();
        sysParamKeys = new HashSet<>();
        executeStatus = true;
        dataMappingManager = new DataMappingManager(actionResponseMap, inputParam);
        runInfo = new RunInfo();
        readContextHolder = new ReadContextHolder();
        dataMappingManager.setReadContextHolder(readContextHolder);
        pullLevel = 0;
    }

    public ExecuteContext(InputParamModule inputParam, String token) {
        actionParamMap = new HashMap<>();
        this.actionResponseMap = new ConcurrentHashMap<>();
        this.paramElementMap = new HashMap<>();
        this.inputParam = inputParam;
        this.token = token;
        this.inputParamKeys = new HashSet<>();
        this.sysParamKeys = new HashSet<>();
        this.executeStatus = true;
        this.dataMappingManager = new DataMappingManager(actionResponseMap, inputParam);
        this.runInfo = new RunInfo();
        this.readContextHolder = new ReadContextHolder();
        this.mockData = inputParam.getMockData();
        dataMappingManager.setReadContextHolder(readContextHolder);

    }

    public DataMappingManager getDataMappingManager() {
        return this.dataMappingManager;
    }

    public void addActionParam(ActionParam actionParam) {
        actionParamMap.put(actionParam.getActionId(), actionParam);
    }

    public ActionParam getActionParam(String actionId) {
        return actionParamMap.get(actionId);
    }

    public void addActionResponse(String actionId, Object resp, boolean isForeach, String actionType) {
        if (resp == null) return;

        /**
         * bmdaction之前返回的都是jsonObject类型，bmd返回的是Array，如果是bmd需要包一个结构返回出去
         */
        if (resp instanceof List && (ActionTypeEnum.BMD_GENERAL_ACTION.getType().equals(actionType) ||
                ActionTypeEnum.BMD_ACTION.getType().equals(actionType)
                || ActionTypeEnum.MICRO_TRANS_ACTION.getType().equalsIgnoreCase(actionType)
                || ActionTypeEnum.SQL_ACTION.getType().equalsIgnoreCase(actionType)
        )) {
            if (!containsActionResp(actionId)) {
                Map<String, Object> executeRes = new HashMap<>();
                executeRes.put("data", resp);
                actionResponseMap.put(actionId, executeRes);
            } else {
                Map<String, Object> res = (Map<String, Object>) actionResponseMap.get(actionId);
                List<List> resultList = (List) res.get("data");
                resultList.addAll((List) resp);
            }
            return;
        }

        //判断是否是 foreach循环的  如果是foreach的循环的 存储的resp结构为List
        if (!isForeach) {
            actionResponseMap.put(actionId, resp);
        } else {
            actionResponseMap.computeIfAbsent(actionId, k -> Lists.newArrayList());
            List<Object> resultList = (List) actionResponseMap.get(actionId);
            resultList.add(resp);
        }
    }


    public void removeActionResponse(String actionId) {
        actionResponseMap.remove(actionId);
    }

    public Object getActionResponse(String actionId) {
        return actionResponseMap.get(actionId);
    }

    public Map<String, Object> getActionResponse() {
        return actionResponseMap;
    }

    public boolean containsActionResp(String actionId) {
        return actionResponseMap.containsKey(actionId);
    }

    public void addParamElement(String paramPath, ParamElement element) {
        paramElementMap.put(paramPath, element);
    }

    public void clearParamElement() {
        this.paramElementMap.clear();
    }

    public void reSetInputParas(List<Map<String, Object>> paras) {
        this.inputParam.setParas(paras);
    }

    public ParamElement getParamElement(String paramPath) {
        return paramElementMap.get(paramPath);
    }

    public boolean isNotExistParamElement(String paramPath) {
        return paramElementMap.get(paramPath) != null ? true : false;
    }

    public InputParamModule getInputParam() {
        return inputParam;
    }

    public String getTenantId() {
        return inputParam.getTenantId();
    }

    public List<Map<String, Object>> getInputParas() {
        return inputParam.getParas();
    }

    public Set<String> getInputParamKeys() {
        return inputParamKeys;
    }

    public void addInputParamKey(String key) {
        inputParamKeys.add(key);
    }

    public void addInputParamKey(String key, String inputParamPart) {
        if (CommonConstant.EXECUTION_PARAM.equals(inputParamPart)) {
            inputParamKeys.add(key);
        } else if (CommonConstant.EXECUTION_SYSPARAM.equals(inputParamPart)) {
            sysParamKeys.add(key);
        }
    }

    public Set<String> getSysParamKeys() {
        return sysParamKeys;
    }

    public void addSysParamKey(String key) {
        sysParamKeys.add(key);
    }

    public boolean isExecuteStatus() {
        return executeStatus;
    }

    public void setExecuteStatus(boolean executeStatus) {
        this.executeStatus = executeStatus;
    }

    public String getCurrentActionId() {
        return currentActionId;
    }

    public void setCurrentActionId(String currentActionId) {
        this.currentActionId = currentActionId;
    }

    public String getToken() {
        return token;
    }

    public Map<String, Object> getEocMap() {
        return inputParam.getEocMap();
    }

    public String getLocale() {
        return locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public RunInfo getRunInfo() {
        return runInfo;
    }

    public void addActionRuninfo(String actionId, int code, String message) {

    }

    public Map<String, ActionParam> getActionParamMap() {
        return actionParamMap;
    }

    public ReadContextHolder getParamGetDataHandler() {
        return readContextHolder;
    }

    public void setBMDtoken(String BMDtoken) {
        this.BMDtoken = BMDtoken;
    }

    public String getBMDtoken() {
        return BMDtoken;
    }

    public String getApplication() {
        return application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getTaskType() {
        return taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getTaskCode() {
        return taskCode;
    }

    public void setTaskCode(String taskCode) {
        this.taskCode = taskCode;
    }
}
