package com.digiwin.athena.executionengine.enumtype;

/**
 * @description: 字段取值类型
 * @author: renwm
 * @date: 2020/6/12 14:27
 */
public enum ValueTypeEnum {

    /**
     * 未知类型
     */
    UNKNOWN("unknown", "未知类型"),

    /**
     * Object类型
     */
    OBJECT("object", "结构类型"),
    /**
     * Array 类型
     */
    ARRAY("Array", "数组类型"),
    /**
     * 字符串类型
     */
    STRING("string", "字符串类型"),
    /**
     * 整数类型
     */
    NUMBER("number", "整数类型"),
    /**
     * 布尔类型
     */
    BOOLEAN("boolean", "布尔类型");
    String type;
    String desc;

    ValueTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static ValueTypeEnum getEnumByType(String type) {
        for (ValueTypeEnum itemEnum : ValueTypeEnum.values()) {

            if (itemEnum.getType().equals(type)) {
                return itemEnum;
            }
        }
        return UNKNOWN;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
