package com.digiwin.athena.executionengine.model.espsdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.athena.executionengine.constant.ModuleProperty;

import java.util.Map;

/**
 * @description: esp sdk调用入参
 * @author: renwm
 * @date: 2020/6/17 10:22
 */
public class EspSdkReqParam {

    private String hostProd;
    private String hostVer;
    private String hostId = ModuleProperty.ESP_AP_ID;
    private String hostAcct;
    private String tenantId;
    private String serviceProd;
    private String serviceProdUid;
    private String serviceName;
    private Map<String, String> datakey;
    private String bodyJsonString;
    private String token;
    private Map<String, Object> eocMap;

    public EspSdkReqParam() {
        hostProd = "Athena";
        hostVer = "1.0";
        hostAcct = ModuleProperty.ESP_HOSTACCT;
    }

    public String getHostProd() {
        return hostProd;
    }

    public void setHostProd(String hostProd) {
        this.hostProd = hostProd;
    }

    public String getHostVer() {
        return hostVer;
    }

    public void setHostVer(String hostVer) {
        this.hostVer = hostVer;
    }

    public String getHostId() {
        return hostId;
    }

    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    public String getHostAcct() {
        return hostAcct;
    }

    public void setHostAcct(String hostAcct) {
        this.hostAcct = hostAcct;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getServiceProd() {
        return serviceProd;
    }

    public void setServiceProd(String serviceProd) {
        this.serviceProd = serviceProd;
    }

    public String getServiceProdUid() {
        return serviceProdUid;
    }

    public void setServiceProdUid(String serviceProdUid) {
        this.serviceProdUid = serviceProdUid;
    }

    public String getServiceName() {
        return serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Map<String, String> getDatakey() {
        return datakey;
    }

    public void setDatakey(Map<String, String> datakey) {
        this.datakey = datakey;
    }

    public String getBodyJsonString() {
        return bodyJsonString;
    }

    public void setBodyJsonString(String bodyJsonString) {
        this.bodyJsonString = bodyJsonString;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Map<String, Object> getEocMap() {
        return eocMap;
    }

    public void setEocMap(Map<String, Object> eocMap) {
        this.eocMap = eocMap;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this, SerializerFeature.WRITE_MAP_NULL_FEATURES);
    }
}
