package com.digiwin.athena.executionengine.provider;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.core.aop.MyExceptionHandler;
import com.digiwin.athena.executionengine.dto.ExportDataDto;
import com.digiwin.athena.executionengine.model.DataDescription;
import com.digiwin.athena.executionengine.model.input.SolutionStepInput;
import com.digiwin.athena.executionengine.service.facade.execution.IExecutionFacade;
import com.digiwin.athena.executionengine.model.input.InputParamModuleBuilder;
import com.digiwin.athena.executionengine.service.facade.execution.ISolutionStepExecutionFacade;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingManager;
import com.digiwin.athena.executionengine.vo.MetricResultVo;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

/**
 * @description:
 * @author: renwm
 * @date: 2020/5/18 13:53
 */
@MyExceptionHandler
@Service("engineExecuteService")
public class ExecuteService implements IExecuteService {
    @Autowired
    private IExecutionFacade executeFacade;

    @Autowired
    private ISolutionStepExecutionFacade solutionStepExecutionFacade;

    @Override
    public Object post(String tenantId, String actionId, List<Map<String, Object>> paras) {
        return executeFacade.execute(new InputParamModuleBuilder()
                .setTenantId(tenantId)
                .setActionId(actionId)
                .setParas(paras)
                .build());
    }

    @Override
    public Object post(String tenantId, String actionId, Map<String, Object> param) {
        return executeFacade.execute(new InputParamModuleBuilder()
                .setTenantId(tenantId)
                .setActionId(actionId)
                .setParam(param)
                .build());
    }

    @Override
    public Object post(String tenantId, String actionId, List<Map<String, Object>> paras, Map<String, Object> eocMap) {
        return executeFacade.execute(new InputParamModuleBuilder()
                .setTenantId(tenantId)
                .setActionId(actionId)
                .setParas(paras)
                .setEocMap(eocMap)
                .build());
    }

    @Override
    public Object post(String tenantId, String actionId, Map<String, Object> param, Map<String, Object> eocMap) {
        return executeFacade.execute(new InputParamModuleBuilder()
                .setTenantId(tenantId)
                .setActionId(actionId)
                .setParam(param)
                .setEocMap(eocMap)
                .build());
    }


    @Override
    public Object post(String tenantId, String actionId, Map<String, Object> param, Map<String, Object> eocMap, Map<String, Object> sysParam) {
        return executeFacade.execute(new InputParamModuleBuilder()
                .setTenantId(tenantId)
                .setActionId(actionId)
                .setParam(param)
                .setEocMap(eocMap)
                .setSysParam(sysParam)
                .build());
    }

    @Override
    public Object post(String tenantId, String actionId, Map<String, Object> param, List<Map<String, Object>> eocMaps, List<String> roles, Map<String, Object> sysParam, DataDescription dataDescription) {
        return executeFacade.execute(new InputParamModuleBuilder()
                .setTenantId(tenantId)
                .setActionId(actionId)
                .setParam(param)
                .setEocMaps(eocMaps)
                .setSysParam(sysParam)
                .setDataDescription(dataDescription)
                .setRoles(roles)
                .build());
    }

    @Override
    public MetricResultVo postQueryMetric(String tenantId, String actionId, Map<String, Object> param, List<Map<String, Object>> eocMaps, List<String> roles, Map<String, Object> sysParam, DataDescription dataDescription) {
        return executeFacade.query(new InputParamModuleBuilder()
                .setTenantId(tenantId)
                .setActionId(actionId)
                .setParam(param)
                .setEocMaps(eocMaps)
                .setSysParam(sysParam)
                .setDataDescription(dataDescription)
                .setRoles(roles)
                .build());
    }

    @Override
    public Object post(String tenantId, String actionId, List<Map<String, Object>> paras, Map<String, Object> eocMap, Map<String, Object> sysParam) {
        return executeFacade.execute(new InputParamModuleBuilder()
                .setTenantId(tenantId)
                .setActionId(actionId)
                .setParas(paras)
                .setEocMap(eocMap)
                .setSysParam(sysParam)
                .build());
    }

    @Override
    public Object post(Object data, String actionId, String tenantId) {
        return executeFacade.generateMetaHandler(new DataMappingManager(data), actionId, tenantId);
    }


    @Override
    public Object post(String tenantId, String actionId, Map<String, Object> param, Map<String, Object> eocMap, Map<String, Object> sysParam, Map<String, Object> mockData) {
        return executeFacade.verify(new InputParamModuleBuilder()
                .setActionId(actionId)
                .setTenantId(tenantId)
                .setParam(param)
                .setEocMap(eocMap)
                .setSysParam(sysParam)
                .setMockData(mockData)
                .build());
    }

    /**
     * ADE调用--新架构
     *
     * @param tenantId
     * @param eocMaps
     * @param sysParam
     * @param solutionStep
     * @return
     */
    @Override
    public Object post(String tenantId, List<Map<String, Object>> eocMaps, Map<String, Object> sysParam, JSONArray solutionStep, Map<String, Object> permissions) {
        return solutionStepExecutionFacade.execute(new SolutionStepInput(tenantId, eocMaps, sysParam, solutionStep, permissions));
    }

    @Override
    public List<ExportDataDto> postExport(String tenantId, List<Map<String, Object>> eocMaps, Map<String, Object> sysParam, JSONArray solutionStep, Map<String, Object> permissions) {
        return solutionStepExecutionFacade.export(new SolutionStepInput(tenantId, eocMaps, sysParam, solutionStep, permissions));
    }

    /**
     * 指标明细导出---多产品线
     *
     * @param tenantId
     * @param eocMaps
     * @param sysParam
     * @param solutionStep
     * @param extension
     * @return
     */
    @Override
    public List<ExportDataDto> postExport(String tenantId, List<Map<String, Object>> eocMaps, Map<String, Object> sysParam, JSONArray solutionStep, JSONObject extension) {
        return solutionStepExecutionFacade.export(new SolutionStepInput(tenantId, eocMaps, sysParam, solutionStep, extension));
    }

    /**
     * 新架构取数---多产品线
     *
     * @param tenantId
     * @param eocMaps
     * @param sysParam
     * @param solutionStep
     * @param extension
     * @return
     */
    @Override
    public Object post(String tenantId, List<Map<String, Object>> eocMaps, Map<String, Object> sysParam, JSONArray solutionStep, JSONObject extension) {
        return solutionStepExecutionFacade.execute(new SolutionStepInput(tenantId, eocMaps, sysParam, solutionStep, extension));
    }
}
