package com.digiwin.athena.executionengine.service.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.executionengine.constant.*;
import com.digiwin.athena.executionengine.dto.ErrorLog;
import com.digiwin.athena.executionengine.exception.BusinessException;
import com.digiwin.athena.executionengine.service.client.IThemeMapClient;
import com.digiwin.athena.executionengine.util.DateUtils;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import com.digiwin.athena.executionengine.util.LogUtils;
import com.digiwin.athena.executionengine.util.ServiceResponseUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

import java.util.*;


/**
 * @description:
 * @author: ZhangJun
 * @create: 2021/10/27
 */
@Service("engineThemeMapClient")
public class ThemeMapClient implements IThemeMapClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(IThemeMapClient.class);

    @Override
    public JSONObject getExecutionRule(String actionId, String tenantId, Set<String> paramKeys, Set<String> sysParamKeys, String token) {
        Map<String, String> headerMap = new HashMap<>(CommonConstant.INITIAL_CAPACITY_INPUT_PARAM);
        headerMap.put("token", token);
        headerMap.put("Content-Type", "application/json;charset=UTF-8");
        headerMap.put(FieldNameConstant.LOCALE, (String) DWServiceContext.getContext().getRequestHeader().get(MetaDataConstant.ACTION_LOCALE));
        headerMap.put(FieldNameConstant.CAMEL_CASE_ROUTER_KEY, String.valueOf(DWServiceContext.getContext().getRequestHeader().get(FieldNameConstant.CAMEL_CASE_ROUTER_KEY)));
        headerMap.put(FieldNameConstant.SECURITY_TOKEN, (String) DWServiceContext.getContext().getRequestHeader().get(FieldNameConstant.SECURITY_TOKEN));

        Map<String, Object> reqMap = new HashMap<>(CommonConstant.INITIAL_CAPACITY_THEMEMAP_DATAINFO);
        reqMap.put("actionId", actionId);
        reqMap.put("tenantId", tenantId);
        reqMap.put("existingActionParams", paramKeys);
        reqMap.put("existingSysParams", sysParamKeys);

        String input = JSON.toJSONString(reqMap);
        LOGGER.info("调用themeMap获取行动逻辑的入参:{}", input);

        String source = (String) DWServiceContext.getContext().getRequestHeader().get(FieldNameConstant.SOURCE);
        if (StringUtils.isNotEmpty(source)) {
            LOGGER.error(String.format(LogConstant.AGILE_DATA + "调用KM入参:%s", "executionengine", JSON.toJSONString(reqMap)));
        }
        String httpContent = null;
        try {
            httpContent = HttpClientUtils.doPost(ModuleProperty.THEMEMAP_ACTION_QUERYEXECUTIONPATH, headerMap, JSON.toJSONString(reqMap));
        } catch (Exception e) {
            ErrorLog errorLog = new ErrorLog();
            errorLog.setErrorCode(AgileDataErrorCodeConstant.AGILE_EXECUTION_PATH_ERROR_CODE);
            errorLog.setErrorLocation("获取数据流配置，数据流id:" + actionId);
            errorLog.setErrorDescription("数据流不存在");
            errorLog.setErrorTimestamp(DateUtils.getCurrentDateTime());
            errorLog.setErrorMessage(String.format("数据流id::%s在图谱中不存在", actionId));
            errorLog.setPossibleCausesAndGuidance("请确认当前是否正在发版，或该数据流是否被误删除");
            LOGGER.error(String.format(LogConstant.AGILE_DATA + "调用KM出参:%s", source, errorLog.toString()));

            LogUtils.buildAgileLog(LogConstant.AGILE_CODE_QUERY_EXECUTION_RULE, AgileDataErrorCodeConstant.AGILE_EXECUTION_PATH_ERROR_CODE, input, "获取行动执行路径失败，可能的原因是：开发平台正在发版，失败原因：【" + e.getMessage() + "】", "\"1.登录开发平台的管理面板，查看系统的更新或发版日志，检查提问时是否正在发版。\n" +
                    "2.若正在发版，等待发版完成。\n" +
                    "3.发版完成后，重新尝试查询指标。\n" +
                    "4.若问题持续，记录当前操作步骤、使用的查询条件和错误信息，联系平台技术支持人员。\"");
            throw new BusinessException(errorLog.getErrorCode(), errorLog.toString());
        }

        LOGGER.info("ThemeMap返回行动逻辑的内容:{}", httpContent);
        LogUtils.buildAgileLog(LogConstant.AGILE_CODE_QUERY_EXECUTION_RULE, LogUtils.SUCCESS, input, httpContent, "");
        if (StringUtils.isNotEmpty(source)) {
            LOGGER.error(String.format(LogConstant.AGILE_DATA + "调用KM出参:%s", "executionengine", httpContent));
        }
        return Optional.ofNullable(httpContent).map(ServiceResponseUtils::getThemeMapResp).orElse(null);
    }

    @Override
    public JSONObject getUIMetaData(String actionId, String token, String tenantId, String locale) {
        Map<String, String> headerMap = new HashMap<>(CommonConstant.INITIAL_CAPACITY_INPUT_PARAM);
        headerMap.put(FieldNameConstant.USER_TOKEN, token);
        headerMap.put(CommonConstant.HTTP_HEADER_CONTENT_TYPE_KEY, "application/json;charset=UTF-8");
        headerMap.put(FieldNameConstant.LOCALE, locale);
        headerMap.put(FieldNameConstant.CAMEL_CASE_ROUTER_KEY, String.valueOf(DWServiceContext.getContext().getRequestHeader().get(FieldNameConstant.CAMEL_CASE_ROUTER_KEY)));
        headerMap.put(FieldNameConstant.SECURITY_TOKEN, (String) DWServiceContext.getContext().getRequestHeader().get(FieldNameConstant.SECURITY_TOKEN));

        Map<String, Object> reqMap = new HashMap<>(CommonConstant.INITIAL_CAPACITY_THEMEMAP_DATAINFO);
        reqMap.put(MetaDataConstant.ACTION_ACTION_ID, actionId);
        reqMap.put(FieldNameConstant.TENANT_ID, tenantId);
        reqMap.put("existingActionParams", Collections.EMPTY_LIST);
        reqMap.put("existingSysParams", Collections.EMPTY_LIST);
        LOGGER.info("调用themeMap获取用于展示界面的元数据:{}", JSON.toJSONString(reqMap));
        String httpContent = HttpClientUtils.doPost(ModuleProperty.THEMEMAP_ACTION_QUERYEXECUTIONPATH, headerMap, JSON.toJSONString(reqMap));
        LOGGER.info("ThemeMap返回元数据:{}", httpContent);
        return Optional.ofNullable(httpContent).map(ServiceResponseUtils::getThemeMapResp).orElse(null);
    }

    @Override
    public JSONObject getExecutionRules(String tenantId, List<String> actionIds, String token) {
        return null;
    }

    @Override
    public JSONObject querySmartDataVariable(String tenantId, List<String> variableIds, String token) {
        Map<String, String> headerMap = new HashMap<>(CommonConstant.INITIAL_CAPACITY_INPUT_PARAM);
        headerMap.put(FieldNameConstant.USER_TOKEN, token);
        headerMap.put(CommonConstant.HTTP_HEADER_CONTENT_TYPE_KEY, "application/json;charset=UTF-8");
        String routerKey = String.valueOf(DWServiceContext.getContext().getRequestHeader().get(FieldNameConstant.CAMEL_CASE_ROUTER_KEY));
        headerMap.put(FieldNameConstant.CAMEL_CASE_ROUTER_KEY, StringUtils.isEmpty(routerKey) || "null".equalsIgnoreCase(routerKey) ? tenantId : routerKey);
        headerMap.put(FieldNameConstant.SECURITY_TOKEN, (String) DWServiceContext.getContext().getRequestHeader().get(FieldNameConstant.SECURITY_TOKEN));

        Map<String, Object> reqMap = new HashMap<>(CommonConstant.INITIAL_CAPACITY_THEMEMAP_DATAINFO);
        reqMap.put(FieldNameConstant.VARIABLE_IDS, variableIds);
        reqMap.put(FieldNameConstant.TENANT_ID, tenantId);
        LOGGER.info(String.format(LogConstant.AGILE_DATA + "获取业务变量的入参:%s header:%s ", "querySmartDataVariable", JSON.toJSONString(reqMap), JSON.toJSONString(headerMap)));
        String httpContent = HttpClientUtils.doPost(ModuleProperty.THEMEMAP_ACTION_QUERYSMARTDATAVARIABLE, headerMap, JSON.toJSONString(reqMap));
        LOGGER.info(String.format(LogConstant.AGILE_DATA + "获取业务变量的出参:%s header:%s ", "querySmartDataVariable", httpContent, JSON.toJSONString(headerMap)));
        return Optional.ofNullable(httpContent).map(ServiceResponseUtils::getThemeMapResp).orElse(null);
    }

    @Override
    public JSONObject queryMetricQuerySchema(Set<String> metricIds) {
        Map<String, String> headerMap = new HashMap<>(CommonConstant.INITIAL_CAPACITY_INPUT_PARAM);
        String token = (String) DWServiceContext.getContext().getRequestHeader().get("token");
        String locale = (String) DWServiceContext.getContext().getRequestHeader().get("locale");
        headerMap.put("token", token);
        headerMap.put("locale", locale);
        headerMap.put("Content-Type", "application/json;charset=UTF-8");
        headerMap.put(FieldNameConstant.CAMEL_CASE_ROUTER_KEY, String.valueOf(DWServiceContext.getContext().getRequestHeader().get(FieldNameConstant.CAMEL_CASE_ROUTER_KEY)));
        headerMap.put(FieldNameConstant.SECURITY_TOKEN, (String) DWServiceContext.getContext().getRequestHeader().get(FieldNameConstant.SECURITY_TOKEN));

        Map<String, Object> reqMap = new HashMap<>(CommonConstant.INITIAL_CAPACITY_THEMEMAP_DATAINFO);
        reqMap.put("indicatorIds", metricIds);

        LOGGER.info("调用themeMap获取行动逻辑的入参:{}", JSON.toJSONString(reqMap));
        String source = (String) DWServiceContext.getContext().getRequestHeader().get(FieldNameConstant.SOURCE);
        if (StringUtils.isNotEmpty(source)) {
            LOGGER.error(String.format(LogConstant.AGILE_DATA + "调用KM入参:%s", "executionengine", JSON.toJSONString(reqMap)));
        }
        String httpContent = null;
        try {
            httpContent = HttpClientUtils.doPost(ModuleProperty.THEMEMAP_ACTION_METRICQUERYSCHEMA, headerMap, JSON.toJSONString(reqMap));
        } catch (Exception e) {
            LOGGER.error("post queryMetricQuerySchema error", e);
        }

        LOGGER.info("ThemeMap返回指标下的querySchema的内容:{}", httpContent);
        return Optional.ofNullable(httpContent).map(ServiceResponseUtils::getThemeMapResp).orElse(null);
    }


}
