package com.digiwin.athena.executionengine.service.facade.analyzer;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2022/5/5
 */
public abstract class AbstractAnalyzerBase implements IAnalyzerFacade {
    private static ThreadLocal<ExecuteContext> localContext = ThreadLocal.withInitial(ExecuteContext::new);

    @Override
    public void analyse(ExecuteContext context, JSONObject data) {
        try {
            localContext.set(context);
            analysisHandler(data);
        } finally {
            localContext.remove();
        }
    }


    /**
     * 子类实现具体分析操作
     *
     * @param data 分析数据
     */
    protected abstract void analysisHandler(JSONObject data);

    /**
     * 获取本地缓存的上下文内容
     *
     * @return
     */
    protected static ExecuteContext getLocalContext() {
        return localContext.get();
    }
}
