package com.digiwin.athena.executionengine.service.facade.convert.trans;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.service.facade.template.ITransSchemaCreator;
import com.digiwin.athena.executionengine.util.ContextUtils;
import com.digiwin.athena.executionengine.util.ReplaceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/9/24
 */
@Service
public class TransDefinitionConvertor implements ITransDefinitionConvertor {

    private static final Logger LOGGER = LoggerFactory.getLogger(TransDefinitionConvertor.class);

    private static final String SUFFIX = "Transformer";
    @Autowired
    private ITransSchemaCreator transSchemaCreator;

    @Override
    public JSONObject convert(JSONObject criteriaDefinition) {

        String technique = criteriaDefinition.getString("technique");
        JSONObject schema = criteriaDefinition.getJSONObject("schema");
        JSONObject variable = ContextUtils.getBean(technique + SUFFIX, ICriteriaTransformer.class)
                .analysisVariable(schema);
        String template = transSchemaCreator.createTransSchemaByTechnique(technique);
        try {
            return JSONObject.parseObject(ReplaceUtils.replace(variable, template));
        } catch (Exception e) {
            LOGGER.error("micTrans定义转换失败,variable:{},template:{}", variable, template, e);
            throw e;
        }
    }

}
