package com.digiwin.athena.executionengine.service.facade.event;

import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/5/20
 */
@Service
public class ActionEventPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionEventPublisher.class);
    private final ApplicationEventPublisher applicationEventPublisher;

    public ActionEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void publishActionEvent(String actionId, ExecuteContext context) {
        LOGGER.info("{} 执行完成触发 ActionEvent", actionId);
        applicationEventPublisher.publishEvent(new ActionEvent(this, actionId, context));
    }
}
