package com.digiwin.athena.executionengine.service.facade.execution;

import com.digiwin.athena.executionengine.model.input.InputParamModule;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingManager;
import com.digiwin.athena.executionengine.vo.MetricResultVo;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2022/5/5
 */
public interface IExecutionFacade {
    /**
     * 执行facade类
     *
     * @param inputParam
     * @return
     * @throws Exception
     */
    Object execute(InputParamModule inputParam);


    /**
     * 指标取数查询
     *
     * @param inputParam
     * @return
     * @throws Exception
     */
    MetricResultVo query(InputParamModule inputParam);

    /**
     * 用于生成数据的元数据，并比较原先预置元数据补充信息
     *
     * @param dataMappingMgr
     * @param actionId
     * @return
     * @throws Exception
     */
    Object generateMetaHandler(DataMappingManager dataMappingMgr, String actionId, String tenantId);

    /**
     * 数据里验证接口
     *
     * @param build
     * @return
     */
    Object verify(InputParamModule build);
}
