package com.digiwin.athena.executionengine.service.facade.router.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.component.param.ParamBase;
import com.digiwin.athena.executionengine.constant.CommonConstant;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;
import com.digiwin.athena.executionengine.constant.MetaDataConstant;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import com.digiwin.athena.executionengine.model.ParamElement;
import com.digiwin.athena.executionengine.model.input.InputParamModule;
import com.digiwin.athena.executionengine.service.facade.analyzer.IAnalyzerFacade;
import com.digiwin.athena.executionengine.service.facade.router.IDataAnalyzerRouterFacade;
import com.digiwin.athena.executionengine.util.ExceptionUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2022/5/5
 */
@Service
public class DataAnalyzerRouterFacade implements IDataAnalyzerRouterFacade {

    private IAnalyzerFacade inputParamAnalysis;
    private IAnalyzerFacade metaActionAnalysis;
    private IAnalyzerFacade metadataAnalysis;

    public DataAnalyzerRouterFacade(@Qualifier("engineInputParamAnalyzer") IAnalyzerFacade inputParamAnalysis,
                                    @Qualifier("engineMetaActionAnalyzer") IAnalyzerFacade metaActionAnalysis,
                                    @Qualifier("engineMetadataAnalyzer") IAnalyzerFacade metadataAnalysis) {
        this.inputParamAnalysis = inputParamAnalysis;
        this.metaActionAnalysis = metaActionAnalysis;
        this.metadataAnalysis = metadataAnalysis;
    }

    @Override
    public ExecuteContext initExecuteContext(InputParamModule inputParamModule, String token) {
        ExecuteContext context = new ExecuteContext(inputParamModule, token);
        Object locale = DWServiceContext.getContext().getRequestHeader().get(MetaDataConstant.ACTION_LOCALE);
        String monitorProcessType = (String) DWServiceContext.getContext().getRequestHeader().get(CommonConstant.MONITOR_PROCESS_TYPE);
        context.setLocale(locale != null ? String.valueOf(locale) : null);
        context.setMonitorProcessType(monitorProcessType);
        context.setSecurityToken((String) DWServiceContext.getContext().getRequestHeader().get(FieldNameConstant.SECURITY_TOKEN));
        String messageId = (String) DWServiceContext.getContext().getRequestHeader().get(CommonConstant.MESSAGE_ID);
        if (StringUtils.isNotEmpty(messageId)) {
            context.setMessageId(Long.valueOf(messageId));
        }
        Map<String, Object> sysParam = context.getInputParam().getSysParam();
        if (sysParam != null) {
            context.setDebug(sysParam.containsKey("debug") ? (Boolean) sysParam.get("debug") : false);
        }

        context.setRootMetricId(context.getInputParam().getActionId());
        // 应用 code
        Object object = DWServiceContext.getContext().getRequestHeader().get("application");
        String application = object != null ? String.valueOf(object) : null;
        context.setApplication(application);
        // 作业类型（DATA_ENTRY-业务数据录入，TASK-任务，MONITOR_RULE-侦测）
        Object taskTypeObj = DWServiceContext.getContext().getRequestHeader().get("taskType");
        context.setTaskType(taskTypeObj != null ? String.valueOf(taskTypeObj) : null);
        // 作业 code
        Object taskCodeObj = DWServiceContext.getContext().getRequestHeader().get("taskCode");
        context.setTaskCode(taskCodeObj != null ? String.valueOf(taskCodeObj) : null);
        return context;
    }

    @Override
    public void analyseInputParam(ExecuteContext context) {
        inputParamAnalysis.analyse(context, null);
    }

    @Override
    public void analyseThemeMapData(ExecuteContext context, JSONObject executionRule) {
        //1.分析元数据并且创建action对象
        metadataAnalysis.analyse(context, executionRule);
        //2.分析action 并执行params
        metaActionAnalysis.analyse(context, executionRule);

        Map<String, ActionParam> actionParamMap = context.getActionParamMap();
        for (Map.Entry<String, ActionParam> actionParamEntry : actionParamMap.entrySet()) {
            ActionParam actionParam = actionParamEntry.getValue();
            List<ParamBase> actionParams = actionParam.getParams();
            checkMapping(actionParam.getRequestParams(), convertToParamSet(actionParams));
        }
    }

    /**
     * List<ParamBase> 转换成Set<String>
     *
     * @param actionParams
     * @return
     */
    private Set<String> convertToParamSet(List<ParamBase> actionParams) {
        Set<String> paramSet = new HashSet<>();
        for (ParamBase paramBase : actionParams) {
            paramSet.add(paramBase.getName());
        }
        return paramSet;
    }

    /**
     * 校验必传字段的映射关系
     *
     * @param paramElements 上下文
     * @param paramSet      执行的action
     */
    private void checkMapping(List<ParamElement> paramElements, Set<String> paramSet) {
        for (ParamElement paramElement : paramElements) {
            if (paramElement.getIsRequired()) {
                String elementParamPath = StringUtils.replaceFirst(paramElement.getParamPath(), paramElement.getActionId() + ".", "");
                boolean isHaveMapping = false;
                if (paramSet.contains(elementParamPath)) {
                    isHaveMapping = true;
                }
                if (!isHaveMapping) {
                    throw ExceptionUtils.buildVerificationException(ErrorCodeEnum.REQUIRE_FIELD_NONE_MAPPING_RELATION, paramElement.getParamPath());
                }
                //递归校验paramElement的children
                List<ParamElement> childElements = paramElement.getChildElements();
                if (CollectionUtils.isEmpty(childElements)) {
                    continue;
                }
                checkMapping(childElements, paramSet);
            }
        }
    }

}
