package com.digiwin.athena.executionengine.util;

import org.apache.commons.lang3.StringUtils;

import java.util.regex.Pattern;

/**
 * <p>功能描述：正则表达式工具类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 * 参考文章：<br>
 * 1. https://blog.walterlv.com/post/match-web-url-using-regex.html<br>
 * 2. https://www.jianshu.com/p/583998f435d0
 *
 * @FileName: RegexUtil
 * @Author: zaregoto
 * @Date: 2022/12/6 13:40
 */
public final class RegexUtil {


    /**
     * 正则：正数、负数、小数
     */
    public static final String REGEX_POSITIVE_NEGATIVE_DECIMAL_NUMBER = "^[-+]?[0-9]*\\.?[0-9]+$";

    private static final Pattern CACHED_PATTERN;

    static {
        CACHED_PATTERN = Pattern.compile(REGEX_POSITIVE_NEGATIVE_DECIMAL_NUMBER);
    }

    /**
     * 判断是否数值
     *
     * @param input 要匹配的字符串
     * @return {@code true}: 匹配<br>{@code false}: 不匹配
     */
    public static boolean isNumber(String input) {
        if (StringUtils.isEmpty(input)) {
            return false;
        }
        return CACHED_PATTERN.matcher(input).matches();
    }

}
