package com.digiwin.athena.executionengine.util;

import com.digiwin.athena.executionengine.core.container.RunInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * 打印执行引擎action pulling过程信息
 *
 * @description:
 * @author: ZhangJun
 * @create: 2021/5/12
 */
public class RunInfoUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunInfoUtils.class);

    /**
     * 执行路径打印方法封装
     * <p>
     * runInfos
     */
    public static void printExecutionProcess(List<RunInfo> runInfos) {
        StringBuilder runInfoBuilder = new StringBuilder();
        runInfoBuilder.append("\r\n");
        runInfoBuilder.append("-------------------action pulling begin-------------------");
        runInfoBuilder.append("\r\n");
        int i = 0;
        for (RunInfo runInfo : runInfos) {
            if (i == 0) {
                runInfoBuilder.append("|---- ");
            } else {
                runInfoBuilder.append("----> ");

            }
            runInfoBuilder.append(runInfo.toString());
            runInfoBuilder.append("\r\n");
            i++;
        }
        runInfoBuilder.append("-------------------action pulling end---------------------");
        LOGGER.info(runInfoBuilder.toString());
    }

}
