package com.digiwin.athena.executionengine.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.MetaDataConstant;
import com.digiwin.athena.executionengine.constant.TransConstant;
import com.digiwin.athena.executionengine.model.trans.GroupElement;
import com.digiwin.athena.executionengine.model.trans.MicroTrans;
import com.digiwin.athena.executionengine.model.trans.Statistic;
import com.digiwin.athena.executionengine.model.trans.StepElement;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.trans.TransEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * 二次计算的工具类
 * @author wuyang
 */
public class TranCovertUtils {

    private static final Logger LOGGER = LoggerFactory.getLogger(TranCovertUtils.class);

    public static MicroTrans buildTransByRecast(List<Map<String, Object>> recasts) {
        MicroTrans microTrans = new MicroTrans();
        List<StepElement> stepElements = new ArrayList<>();
        int stepIndex = 0;
        //第一步先展平
        stepElements.add(StepElement.buildSpread(TransConstant.COMPONENT_TYPE_SPREAD + "_" + ++stepIndex));
        //第二步转为层次结构
        stepElements.add(StepElement.buildTruncateKey(TransConstant.COMPONENT_TYPE_TRUNCATEKEY + "_" + stepIndex));

        List<Map<String, Object>> newRecasts = new ArrayList<>();
        if (!CollectionUtils.isEmpty(recasts)) {
            //排序二次计算condition
            TreeMap<Integer, Map<String, Object>> orderedRecastMap = new TreeMap<>();
            for (Map<String, Object> recast : recasts) {
                String type = (String) recast.get(TransConstant.TRANCOVERT_NAME);
                int index = TransConstant.RECAST_CONDITION_NAME_SORTS.indexOf(type);
                if (index != -1) {
                    orderedRecastMap.put(index, recast);
                }
            }
            newRecasts = new ArrayList<>(orderedRecastMap.values());
        }
        //如果有维度+度量，则记录下需要去重的字段
        List<String> fields = new ArrayList<>(8);
        for (Map<String, Object> recast : newRecasts) {
            String name = (String) recast.get(TransConstant.TRANCOVERT_NAME);
            if(TransConstant.COMPONENT_TYPE_FILTER.equals(name) ||
                    TransConstant.COMPONENT_TYPE_MEASURE.equals(name) ||
                    TransConstant.COMPONENT_TYPE_HAVING.equals(name) ||
                    TransConstant.COMPONENT_TYPE_SORT.equals(name) ||
                    TransConstant.COMPONENT_TYPE_LIMIT.equals(name)
            ){
                if (recast.get(TransConstant.TRANCOVERT_CONDITION) == null) {
                    continue;
                }
                if (recast.get(TransConstant.TRANCOVERT_CONDITION) instanceof List) {
                    if (CollectionUtils.isEmpty((Collection<?>) recast.get(TransConstant.TRANCOVERT_CONDITION))) {
                        continue;
                    }
                }
                if (recast.get(TransConstant.TRANCOVERT_CONDITION) instanceof Map) {
                    if (CollectionUtils.isEmpty((Map<?, ?>) recast.get(TransConstant.TRANCOVERT_CONDITION))) {
                        continue;
                    }
                }
            }

            //过滤
            if (TransConstant.COMPONENT_TYPE_FILTER.equals(name)) {
                stepElements.add(StepElement.buildFilter(TransConstant.COMPONENT_TYPE_FILTER + "_" + ++stepIndex,
                        (Map<String, Object>) recast.get(TransConstant.TRANCOVERT_CONDITION)));
                //维度+度量（group）
            } else if (TransConstant.COMPONENT_TYPE_MEASURE.equals(name)) {
                buildDistinctField(fields, (Map<String, Object>) recast.get(TransConstant.TRANCOVERT_CONDITION));
                stepElements.add(StepElement.buildGroup(TransConstant.COMPONENT_TYPE_GROUP + "_" + ++stepIndex,
                        (Map<String, Object>) recast.get(TransConstant.TRANCOVERT_CONDITION)));
                //count,sum,ave才做distinct
                if (!CollectionUtils.isEmpty(fields)) {
                    //做去重动作（distinct）
                    stepElements.add(StepElement.buildDistinct(TransConstant.COMPONENT_TYPE_DISTINCT + "_" + ++stepIndex,
                            fields));
                }
                //去重（distinct）
            } else if(TransConstant.COMPONENT_TYPE_DISTINCT.equals(name)) {
                fields = (List<String>) recast.get(MetaDataConstant.METADATAS_PARAM_FIELDS);
                stepElements.add(StepElement.buildDistinct(TransConstant.COMPONENT_TYPE_DISTINCT + "_" + ++stepIndex,
                        fields));
                //计算（calculate）
            }else if(TransConstant.COMPONENT_TYPE_CALCULATE.equals(name)){
                if(recast.get(TransConstant.TRANCOVERT_RULE) != null
                        && !CollectionUtils.isEmpty((Collection<?>) recast.get(TransConstant.TRANCOVERT_RULE))){
                    stepElements.add(StepElement.buildCalculate(TransConstant.COMPONENT_TYPE_CALCULATE + "_" + ++stepIndex,
                            (List) recast.get(TransConstant.TRANCOVERT_RULE)));
                }
                //过滤（having）
            } else if (TransConstant.COMPONENT_TYPE_HAVING.equals(name)) {
                stepElements.add(StepElement.buildHaving(TransConstant.COMPONENT_TYPE_HAVING + "_" + ++stepIndex,
                        (Map<String, Object>) recast.get(TransConstant.TRANCOVERT_CONDITION)));
                //排序(group)
            } else if (TransConstant.COMPONENT_TYPE_SORT.equals(name)) {
                stepElements.add(StepElement.buildGroup(TransConstant.COMPONENT_TYPE_GROUP + "-sort_" + ++stepIndex,
                        (Map<String, Object>) recast.get(TransConstant.TRANCOVERT_CONDITION)));
                //取值范围（limit）
            } else if (TransConstant.COMPONENT_TYPE_LIMIT.equals(name)) {
                stepElements.add(StepElement.buildGroup(TransConstant.COMPONENT_TYPE_GROUP + "-limit_" + ++stepIndex,
                        (Map<String, Object>) recast.get(TransConstant.TRANCOVERT_CONDITION)));
                //增加序号（seqNo）
            } else if(TransConstant.COMPONENT_TYPE_SEQNO.equals(name)){
                stepElements.add(StepElement.buildGroup(TransConstant.COMPONENT_TYPE_GROUP + "-seqNo_" + ++stepIndex,
                        (Map<String, Object>) recast.get(TransConstant.TRANCOVERT_CONDITION)));
                //新增控制输出参数
            } else if(TransConstant.COMPONENT_TYPE_CHOOSE.equals(name)){
                //当fields为空的时候，就不需要控制，没有意义
                if(recast.get(MetaDataConstant.METADATAS_PARAM_FIELDS) == null
                        || recast.get(MetaDataConstant.METADATAS_PARAM_FIELDS) instanceof Map
                ){
                    continue;
                }
                if(recast.get(MetaDataConstant.METADATAS_PARAM_FIELDS) instanceof List){
                    if (CollectionUtils.isEmpty((Collection<?>) recast.get(MetaDataConstant.METADATAS_PARAM_FIELDS))) {
                        continue;
                    }
                }
                stepElements.add(StepElement.buildChoose(TransConstant.COMPONENT_TYPE_GROUP + "-choose_" + ++stepIndex,
                        (String) recast.get(MetaDataConstant.ACTION_TYPE),
                        (List<String>) recast.get(MetaDataConstant.METADATAS_PARAM_FIELDS)));
            }
        }
        microTrans.setStep(stepElements);
        microTrans.setOrder(MicroTrans.buildOrderListByStepList(stepElements));
        return microTrans;
    }

    public static Object runTransByRecast(List<Map<String, Object>> recasts, Object data, String tenantId) {
        try {
            MicroTrans microTrans = TranCovertUtils.buildTransByRecast(recasts);
            TransDataManger transDataManger = new TransDataManger(JsonUtil.getObject(JsonUtil.getJsonString(microTrans)), data, tenantId);
            TransEngine transEngine = ContextUtils.getBean(TransEngine.class);
            return transEngine.runEngine(transDataManger);
        } catch (Exception e) {
            LOGGER.error("原数据：" + JsonUtil.getJsonString(data) + "recasts：" + JsonUtil.getJsonString(recasts));
            e.printStackTrace();
        }
        return "";
    }

    private static void buildDistinctField(List<String> fields, Map<String, Object> conditions) {

        GroupElement groupElement = JsonUtil.getObject(JsonUtil.getJsonString(conditions),
                GroupElement.class);
        fields.addAll(groupElement.getFields());
        List<Statistic> statistics = groupElement.getStatistics();
        for (Statistic statistic : statistics) {
            //当他类型为 ，不需要进行去重处理
            if (TransConstant.GROUP_METHOD_COUNT.equals(statistic.getStatisticalMethod())
                    || TransConstant.GROUP_METHOD_SUM.equals(statistic.getStatisticalMethod())
                    || TransConstant.GROUP_METHOD_AVERAGE.equals(statistic.getStatisticalMethod())
                    || TransConstant.GROUP_METHOD_MIN.equals(statistic.getStatisticalMethod())
                    || TransConstant.GROUP_METHOD_MAX.equals(statistic.getStatisticalMethod())
            ) {
                fields.add(statistic.getNewField());
            }
        }
    }


    //TODO 临时将二次计算里面的start_time和end_time提出来，并且包装成data.data
    public static Object buildPullingData(Object transData) {
        Map<String, Object> responseData = new HashMap<>(1);
        Map<String, Object> data = new HashMap<>(3);
        if (transData instanceof List) {
            JSONArray objects = JsonUtil.getList(JsonUtil.getJsonString(transData));
            JSONArray newObjects = new JSONArray();
            for (int i = 0; i < objects.size(); i++) {
                JSONObject object = objects.getJSONObject(i);
                if (!data.keySet().contains("start_time") && object.get("start_time") != null) {
                    data.put("start_time", object.get("start_time"));
                }
                if (!data.keySet().contains("end_time") && object.get("end_time") != null) {
                    data.put("end_time", object.get("end_time"));
                }
                newObjects.add(object);
            }
            data.put("data", newObjects);
            responseData.put("data", data);
            LOGGER.error("二次计算的data：{" + JsonUtil.getJsonString(responseData) + " }");
            return data;
        }
        return transData;
    }

    public static MicroTrans buildTransByJsonArray(JSONArray microTrans) {
        return null;
    }
}
