/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.core.aop.ActionMock;
import com.digiwin.athena.executionengine.core.aop.Debug;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.dto.ErrorLog;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import com.digiwin.athena.executionengine.exception.BusinessException;
import com.digiwin.athena.executionengine.model.DataDescription;
import com.digiwin.athena.executionengine.util.DateUtils;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import com.digiwin.athena.executionengine.util.JsonResolverUtils;
import com.digiwin.athena.executionengine.util.LogUtils;
import com.digiwin.athena.executionengine.util.ReplaceUtils;
import com.digiwin.athena.smartdata.sdk.config.DatasourceUrl;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="SqlAction")
public class SqlAction
extends ActionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlAction.class);
    private static final String SUPER_USER = "superadmin";
    private static final String PLACE_HOLDER = "$(param)";
    private static final String SQLSERVER = "sqlServer";
    private static final String ORACLE = "oracle";
    private static final String MYSQL = "mySql";
    private static final String MYSQL_PAGE = " LIMIT $(offset),$(pageSize)";
    private static final String SQLSERVER_PAGE = " OFFSET $(offset) ROWS FETCH NEXT $(pageSize) ROWS ONLY";
    private static final String ORACLE_PAGE = "SELECT t3.* FROM(SELECT t2.*,ROWNUM rn FROM(%s) t2 WHERE ROWNUM <= $(endNo)) t3 WHERE t3.rn >= $(startNo)";

    @Override
    @ActionMock
    @Debug
    protected Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        String logSql = "";
        try {
            String whereSql;
            String productLine;
            DataDescription dataDescription = context.getInputParam().getDataDescription();
            if (dataDescription.getProductLineRows() != null && !dataDescription.getProductLineRows().isEmpty()) {
                productLine = actionParam.getMetaObj().containsKey((Object)"productLine") ? actionParam.getMetaObj().getString("productLine") : "ERP";
                for (int i = 0; i < dataDescription.getProductLineRows().size(); ++i) {
                    JSONObject rowJson = dataDescription.getProductLineRows().getJSONObject(i);
                    if (!productLine.equals(rowJson.getString("productLine"))) continue;
                    dataDescription.setPermissions(rowJson.getJSONObject("row"));
                    break;
                }
            } else {
                productLine = "ERP";
            }
            JSONObject querySchema = actionParam.getQuerySchema();
            boolean isSuperUser = this.isSuperUser(context.getInputParam().getRoles());
            Map<String, String> paramMap = this.generateParam(querySchema, reqMap, actionParam.getActionId());
            if (!isSuperUser && StringUtils.isNotEmpty((CharSequence)(whereSql = this.generatePermissionParam(context.getInputParam().getDataDescription())))) {
                paramMap.put("param", whereSql);
            }
            String selectSql = querySchema.getString("selectSql");
            selectSql = this.processSql(isSuperUser, context.getInputParam().getDataDescription(), selectSql);
            String totalSql = querySchema.getString("totalSql");
            totalSql = this.processSql(isSuperUser, context.getInputParam().getDataDescription(), totalSql);
            selectSql = ReplaceUtils.replace(paramMap, selectSql);
            totalSql = ReplaceUtils.replace(paramMap, totalSql);
            logSql = selectSql;
            JSONArray list = new JSONArray();
            int pageNo = 0;
            long startTime = System.currentTimeMillis();
            String dbType = this.getDbType(context.getInputParam().getDataDescription(), productLine);
            boolean isFirst = true;
            while (true) {
                Integer total;
                JSONObject detail;
                JSONObject dataNode;
                JSONObject data;
                String newSelectSql = this.appendPagination(selectSql, dbType, pageNo);
                if (isFirst && context.isDebug()) {
                    isFirst = false;
                    context.getQuerySqlMap().put(actionParam.getActionId(), Arrays.asList(newSelectSql, totalSql));
                }
                if ((data = this.doQuery(newSelectSql, totalSql, context, productLine)) == null || data.isEmpty() || (dataNode = data.getJSONObject("data")) == null || dataNode.isEmpty() || !dataNode.containsKey((Object)"detail") || (detail = dataNode.getJSONObject("detail")) == null || detail.isEmpty() || !detail.containsKey((Object)"total") || !detail.containsKey((Object)"list") || (total = Integer.valueOf(Integer.parseInt(detail.getString("total")))) == 0) break;
                if (total >= 150000) {
                    throw new BusinessException(ErrorCodeEnum.ACTION_PULLING_DATA_OVERFLOW);
                }
                list.addAll((Collection)detail.getJSONArray("list"));
                if (list.size() >= total) break;
                ++pageNo;
            }
            long timeTaken = System.currentTimeMillis() - startTime;
            LOGGER.info(String.format("actionId\uff1a%s\uff0c\u67e5\u8be2\u8017\u65f6:%sms\uff0c\u67e5\u8be2\u7b14\u6570:%s,\u67e5\u8be2sql:%s", actionParam.getActionId(), timeTaken, list.size(), selectSql));
            LogUtils.buildAgileLog("executeSqlAction", LogUtils.SUCCESS, "actionId:" + actionParam.getActionId() + ",action\u5165\u53c2:" + JSONObject.toJSONString(reqMap) + "\uff0c\u67e5\u8be2sql:" + selectSql, "\u6570\u636e\u7b14\u6570\uff1a" + list.size(), "");
            context.setExecuteStatus(true);
            return list;
        }
        catch (Exception e) {
            context.setExecuteStatus(false);
            ErrorLog errorLog = new ErrorLog();
            if (e instanceof BusinessException) {
                BusinessException be = (BusinessException)((Object)e);
                errorLog.setErrorCode(be.getErrorCode());
                errorLog.setErrorMessage(be.getMessage());
            } else {
                errorLog.setErrorCode("U.EE.500.0014");
                errorLog.setErrorMessage(e.getMessage());
            }
            errorLog.setErrorLocation("sql\u6267\u884c\u8282\u70b9\uff0cactionId:" + actionParam.getActionId());
            errorLog.setErrorDescription(e.getMessage());
            errorLog.setErrorTimestamp(DateUtils.getCurrentDateTime());
            errorLog.setPossibleCausesAndGuidance("\u8bf7\u68c0\u67e5sql\u8bed\u6cd5\u662f\u5426\u6b63\u786e,\u8282\u70b9id:" + actionParam.getActionId());
            if (context.getErrorLog() == null) {
                context.setErrorLog(errorLog);
            }
            LOGGER.error(String.format("agiledata_%s_sqlAction\u83b7\u53d6\u6570\u636e\u5f02\u5e38:%s", "executionengine", e.getMessage()));
            LogUtils.buildAgileLog("executeSqlAction", "U.EE.500.0014", "actionId:" + actionParam.getActionId() + ",action\u5165\u53c2:" + JSONObject.toJSONString(reqMap) + "\uff0c\u67e5\u8be2sql:" + logSql, "SQL\u6267\u884c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u3010" + e.getMessage() + "\u3011", "\"1.\u6253\u5f00\u6570\u636e\u5e93\u7ba1\u7406\u5de5\u5177\uff08\u5982MySQLWorkbench\u3001SQLServerManagementStudio\u7b49\uff09\u628a\u62a5\u9519\u7684SQL\u8bed\u53e5\u7c98\u8d34\u5230\u67e5\u8be2\u7a97\u53e3\u3002\n2.\u8fd0\u884cSQL\u8bed\u53e5\uff0c\u6839\u636e\u6570\u636e\u5e93\u8fd4\u56de\u7684\u9519\u8bef\u4fe1\u606f\u4fee\u6539\u8bed\u6cd5\u9519\u8bef\uff0c\u5e76\u68c0\u67e5SQL\u4e2d\u8868\u540d\u3001\u5b57\u6bb5\u540d\u3001\u5173\u952e\u5b57\u548c\u51fd\u6570\u4f7f\u7528\u662f\u5426\u6b63\u786e\u3002\n3.\u82e5\u4ecd\u62a5\u9519\uff0c\u5c06SQL\u8bed\u53e5\u548c\u9519\u8bef\u4fe1\u606f\u63d0\u4f9b\u7ed9\u7cfb\u7edf\u7ba1\u7406\u5458\u3002\"");
            throw e;
        }
    }

    private String appendPagination(String selectSql, String dbType, int pageNo) {
        switch (dbType) {
            case "oracle": {
                return this.genOraclePageSql(selectSql, pageNo + 1);
            }
            case "mySql": {
                return this.genMysqlPageSql(selectSql, 10000 * pageNo);
            }
        }
        return this.genSqlServerPageSql(selectSql, 10000 * pageNo);
    }

    private String processSql(boolean isSuperUser, DataDescription dataDescription, String sql) {
        if (StringUtils.isEmpty((CharSequence)sql)) {
            return sql;
        }
        if (sql.indexOf(PLACE_HOLDER) == -1) {
            return sql;
        }
        if (isSuperUser || CollectionUtils.isEmpty((Map)dataDescription.getPermissions())) {
            return sql.replaceAll("(\\s+and\\s+\\$\\(param\\))", "");
        }
        return sql;
    }

    private boolean isSuperUser(List<String> roles) {
        if (CollectionUtils.isEmpty(roles)) {
            return false;
        }
        return roles.contains(SUPER_USER);
    }

    private String generatePermissionParam(DataDescription dataDescription) {
        JSONObject permissions = dataDescription.getPermissions();
        if (CollectionUtils.isEmpty((Map)permissions)) {
            return null;
        }
        return this.processFilter(permissions);
    }

    private String processFilter(JSONObject filter) {
        StringBuilder whereBuilder = new StringBuilder();
        String logic = filter.getString("filterType");
        if ("and".equalsIgnoreCase(logic) || "or".equalsIgnoreCase(logic)) {
            whereBuilder.append("(");
            JSONArray children = filter.getJSONArray("filterValue");
            for (int i = 0; i < children.size(); ++i) {
                JSONObject child = children.getJSONObject(i);
                whereBuilder.append(this.processFilter(child));
                if (i >= children.size() - 1) continue;
                whereBuilder.append(" ").append(logic).append(" ");
            }
            whereBuilder.append(")");
        } else {
            String filterField = filter.getString("filterField");
            String operator = this.getSqlOpt(filter.getString("filterType"));
            String filterValue = filter.getString("filterValue");
            switch (operator) {
                case "like": {
                    filterValue = "%" + filterValue + "%";
                    break;
                }
                case "rl": {
                    operator = "like";
                    filterValue = filterValue + "%";
                    break;
                }
                case "nrl": {
                    operator = "not like";
                    filterValue = filterValue + "%";
                    break;
                }
                case "ll": {
                    operator = "like";
                    filterValue = "%" + filterValue;
                    break;
                }
                case "nll": {
                    operator = "not like";
                    filterValue = "%" + filterValue;
                    break;
                }
                case "in": 
                case "not in": {
                    filterValue = "(" + filterValue + ")";
                    break;
                }
            }
            if ("null".equalsIgnoreCase(operator)) {
                whereBuilder.append(filterField).append(" is null");
            } else if ("not null".equalsIgnoreCase(operator)) {
                whereBuilder.append(filterField).append(" is not null");
            } else {
                whereBuilder.append(filterField).append(" ").append(operator).append(" '").append(filterValue).append("'");
            }
        }
        return whereBuilder.toString();
    }

    private String getSqlOpt(String filterType) {
        switch (filterType) {
            case "eq": {
                return "=";
            }
            case "ne": {
                return "!=";
            }
            case "like": {
                return "like";
            }
            case "gt": {
                return ">";
            }
            case "gte": {
                return ">=";
            }
            case "lt": {
                return "<";
            }
            case "lte": {
                return "<=";
            }
            case "in": {
                return "in";
            }
            case "nin": {
                return "not in";
            }
        }
        return filterType;
    }

    private JSONObject doQuery(String selectSql, String totalSql, ExecuteContext context, String productLine) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("token", context.getToken());
        headerMap.put("Content-Type", "application/json;charset=UTF-8");
        headerMap.put("routerKey", context.getRouterKey());
        headerMap.put("Accept", "application/json;charset=UTF-8");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("totalSQL", totalSql);
        param.put("selectSQL", selectSql);
        param.put("productLine", productLine);
        String jsonParam = JsonResolverUtils.toJsonString(param);
        String httpRespContent = HttpClientUtils.doPost(DatasourceUrl.dcpUrl + "/api/ddl/execute/and/return", headerMap, jsonParam);
        return JSONObject.parseObject((String)httpRespContent);
    }

    private String getDbType(DataDescription dataDescription, String productLine) {
        JSONArray productLineInfo = dataDescription.getProductLineInfo();
        if (CollectionUtils.isEmpty((Collection)productLineInfo)) {
            return SQLSERVER;
        }
        JSONObject dbObject = null;
        if (productLine != null) {
            for (int i = 0; i < productLineInfo.size(); ++i) {
                JSONObject productLineObj = productLineInfo.getJSONObject(i);
                if (!productLine.equals(productLineObj.getString("productLine"))) continue;
                dbObject = productLineObj;
                break;
            }
            if (dbObject == null) {
                return SQLSERVER;
            }
        } else {
            dbObject = productLineInfo.getJSONObject(0);
        }
        switch (dbObject.getString("dbType")) {
            case "oracle": {
                return ORACLE;
            }
            case "mySql": {
                return MYSQL;
            }
        }
        return SQLSERVER;
    }

    private String genSqlServerPageSql(String selectSql, int offset) {
        HashMap<String, Integer> replaceParam = new HashMap<String, Integer>(2);
        replaceParam.put("offset", offset);
        replaceParam.put("pageSize", 10000);
        String sql = selectSql + SQLSERVER_PAGE;
        return ReplaceUtils.replace(replaceParam, sql);
    }

    private String genMysqlPageSql(String selectSql, int offset) {
        HashMap<String, Integer> replaceParam = new HashMap<String, Integer>(2);
        replaceParam.put("offset", offset);
        replaceParam.put("pageSize", 10000);
        String sql = selectSql + MYSQL_PAGE;
        return ReplaceUtils.replace(replaceParam, sql);
    }

    private String genOraclePageSql(String selectSql, int pageNo) {
        HashMap<String, Integer> replaceParam = new HashMap<String, Integer>(2);
        replaceParam.put("startNo", (pageNo - 1) * 10000 + 1);
        replaceParam.put("endNo", pageNo * 10000);
        String sql = String.format(ORACLE_PAGE, selectSql);
        return ReplaceUtils.replace(replaceParam, sql);
    }

    private Map<String, String> generateParam(JSONObject querySchema, Map<String, Object> reqData, String actionId) {
        JSONArray params = querySchema.getJSONArray("params");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        params.forEach(param -> {
            JSONObject paramJsonObject = (JSONObject)param;
            if (paramJsonObject.containsKey((Object)"source")) {
                String inputParamKey = paramJsonObject.getString("source");
                String dataName = paramJsonObject.getString("data_name");
                String interval = paramJsonObject.getString("interval");
                String inputValue = (String)reqData.get(inputParamKey);
                if (StringUtils.isNotEmpty((CharSequence)inputValue) && inputValue.contains("#")) {
                    int splitPos = inputValue.indexOf(35);
                    if ("between-left".equals(interval)) {
                        inputValue = inputValue.substring(0, splitPos);
                    } else if ("between-right".equals(interval)) {
                        inputValue = inputValue.substring(splitPos + 1);
                    } else {
                        LOGGER.info("BMDAction:{}\u66ff\u6362\u67e5\u8be2\u53c2\u6570source:{}\u65f6\u9047\u5230\u672a\u8bc6\u522b\u7684interval:{}", new Object[]{actionId, inputParamKey, interval});
                    }
                }
                if (StringUtils.isEmpty((CharSequence)inputValue)) {
                    inputValue = this.getDefaultSetting(paramJsonObject);
                }
                paramMap.put(dataName, inputValue);
            } else {
                String dataName = paramJsonObject.getString("data_name");
                String inputValue = (String)reqData.get(dataName);
                if (StringUtils.isEmpty((CharSequence)inputValue)) {
                    inputValue = this.getDefaultSetting(paramJsonObject);
                }
                paramMap.put(dataName, inputValue);
            }
        });
        return paramMap;
    }

    private String getDefaultSetting(JSONObject paramJsonObject) {
        String method;
        String val = null;
        if (!paramJsonObject.containsKey((Object)"paramDefault")) {
            LOGGER.warn("\u56fe\u8c31\u4e2d\u7684\u6761\u4ef6\u53c2\u6570\u5e76\u672a\u83b7\u5f97\u4e14\u672a\u8bbe\u5b9adefault\u9ed8\u8ba4\u503c");
            return null;
        }
        JSONObject paramDefault = paramJsonObject.getJSONObject("paramDefault");
        switch (method = paramDefault.getString("method")) {
            case "firstDayOfMonthYearAgo": {
                val = DateUtils.firstDayOfMonthYearAgo("");
                break;
            }
            case "firstDateOfLastMonth": {
                val = DateUtils.getfirstDayOfLastMonth("");
                break;
            }
            case "lastDateOfLastMonth": {
                val = DateUtils.getLastDayOfLastMonth("");
                break;
            }
            case "firstDayOfThisYear": {
                val = DateUtils.firstDayOfThisYear();
                break;
            }
            case "lastDayOfThisYear": {
                val = DateUtils.lastDayOfThisYear();
                break;
            }
            case "firstDateOfMonth": {
                val = DateUtils.firstDayOfThisMonth();
                break;
            }
            case "lastDateOfMonth": {
                val = DateUtils.lastDayOfThisMonth();
                break;
            }
            case "custom": {
                val = paramDefault.getString("value");
                break;
            }
            default: {
                LOGGER.warn("\u672a\u8bc6\u522b\u7684 method \u7c7b\u578b: {}", (Object)method);
            }
        }
        return val;
    }
}

