/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.component.param;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.param.ParamBase;
import com.digiwin.athena.executionengine.component.param.ParamFactory;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingManager;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseParam
extends ParamBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaseParam.class);
    private ParamBase caseInput;
    private List<CaseBranch> caseBranches = Lists.newArrayList();
    private ParamBase eligibleThen;

    @Override
    protected void initProperty(JSONObject paramObj) {
        this.caseInput = Optional.ofNullable(paramObj.getJSONObject("caseInput")).map(obj -> ParamFactory.createParam(obj)).orElse(null);
        if (this.caseInput == null) {
            return;
        }
        this.caseInput.name = this.name;
        JSONArray branches = paramObj.getJSONArray("caseBranches");
        if (CollectionUtils.isEmpty((Collection)branches)) {
            return;
        }
        int len = branches.size();
        for (int i = 0; i < len; ++i) {
            JSONObject caseBranchObj = branches.getJSONObject(i);
            ParamBase whenParam = ParamFactory.createParam(caseBranchObj.getJSONObject("when"));
            ParamBase thenParam = ParamFactory.createParam(caseBranchObj.getJSONObject("then"));
            if (whenParam == null || thenParam == null) continue;
            whenParam.name = this.name;
            thenParam.name = this.name;
            this.caseBranches.add(new CaseBranch(whenParam, thenParam));
        }
    }

    @Override
    public boolean eval(ExecuteContext context) {
        if (!this.doEval(this.caseInput, context)) {
            LOGGER.error("caseInput eval \u5931\u8d25,CaseParam\u6267\u884c\u5931\u8d25");
            return false;
        }
        Object inputVal = this.getDataByTemplatePath(context, this.caseInput);
        LOGGER.info("caseInput\u53d6\u5230\u7684\u503c:{}", inputVal);
        for (CaseBranch branchParam : this.caseBranches) {
            if (!this.doEval(branchParam.whenParam, context)) {
                LOGGER.error("whenParam eval\u5931\u8d25,\u5373\u5c06continue\u4e0b\u4e00\u4e2awhenParam");
                continue;
            }
            Object whenVal = this.getDataByTemplatePath(context, branchParam.whenParam);
            LOGGER.info("whenVal\u53d6\u5230\u7684\u503c:{}", whenVal);
            if (!Objects.equals(inputVal, whenVal)) continue;
            this.eligibleThen = branchParam.thenParam;
            this.value = this.eligibleThen.getValue();
            return branchParam.thenParam.eval(context);
        }
        LOGGER.warn("\u6ca1\u6709\u5339\u914d\u7684casewhen\u6761\u4ef6");
        return false;
    }

    private boolean doEval(ParamBase paramBase, ExecuteContext context) {
        try {
            if (paramBase.eval(context)) {
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("paramBase eval \u5f02\u5e38", (Throwable)e);
        }
        return false;
    }

    private Object getDataByTemplatePath(ExecuteContext context, ParamBase paramBase) {
        String templatePath = context.getDataMappingManager().getDatMappingHandler(context.getInputParam().getActionId(), paramBase.getSrcActionId(context)).getPathTemplateByPath(paramBase.getValue());
        return paramBase.getData(context, templatePath);
    }

    @Override
    public String getSrcActionId(ExecuteContext context) {
        return this.eligibleThen.getSrcActionId(context);
    }

    @Override
    public Object getData(ExecuteContext context, String jsonPath) {
        return this.eligibleThen.getData(context, jsonPath);
    }

    @Override
    public Object getData(ExecuteContext context, DataMappingManager dataMappingManager, String requestActionId, String paramPath) throws Exception {
        return this.eligibleThen.getData(context, dataMappingManager, requestActionId, paramPath);
    }

    @Override
    public int getDataSize(DataMappingManager dataMappingManager, String requestActionId, String paramPath, String jsonPath) {
        return this.eligibleThen.getDataSize(dataMappingManager, requestActionId, paramPath, jsonPath);
    }

    @Override
    public int getRootSize(DataMappingManager dataMappingManager, String requestActionId) {
        return this.eligibleThen.getRootSize(dataMappingManager, requestActionId);
    }

    @Override
    public boolean isCollectionRoot(DataMappingManager dataMappingManager, String requestActionId) {
        return this.eligibleThen.isCollectionRoot(dataMappingManager, requestActionId);
    }

    @Override
    public boolean isCollectionParam(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return this.eligibleThen.isCollectionParam(dataMappingManager, requestActionId, paramPath);
    }

    @Override
    public boolean isObjectCollectionParam(DataMappingManager dataMappingManager, String requestActionId, String param) {
        return this.eligibleThen.isObjectCollectionParam(dataMappingManager, requestActionId, param);
    }

    @Override
    public List<String> getCollectionPath(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return this.eligibleThen.getCollectionPath(dataMappingManager, requestActionId, paramPath);
    }

    @Override
    public int getPathDataSize(DataMappingManager dataMappingManager, String requestActionId, String paramPath, String fixedPath) {
        return this.eligibleThen.getPathDataSize(dataMappingManager, requestActionId, paramPath, fixedPath);
    }

    @Override
    public int getPathDataSize(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return this.eligibleThen.getPathDataSize(dataMappingManager, requestActionId, paramPath);
    }

    @Override
    public boolean pathIsExistsInData(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return this.eligibleThen.pathIsExistsInData(dataMappingManager, requestActionId, paramPath);
    }

    @Override
    public int countCollectionInPath(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return this.eligibleThen.countCollectionInPath(dataMappingManager, requestActionId, paramPath);
    }

    @Override
    public void setParentPathPos(DataMappingManager dataMappingManager, String requestActionId, String paramPath, int pos) {
        this.eligibleThen.setParentPathPos(dataMappingManager, requestActionId, paramPath, pos);
    }

    @Override
    public void setPathPos(DataMappingManager dataMappingManager, String requestActionId, String paramPath, int pos) {
        this.eligibleThen.setPathPos(dataMappingManager, requestActionId, paramPath, pos);
    }

    @Override
    public String getDataJsonPath(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return this.eligibleThen.getDataJsonPath(dataMappingManager, requestActionId, paramPath);
    }

    private class CaseBranch {
        private ParamBase whenParam;
        private ParamBase thenParam;

        public CaseBranch(ParamBase whenParam, ParamBase thenParam) {
            this.whenParam = whenParam;
            this.thenParam = thenParam;
        }
    }
}

