/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.client.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.dto.DataCenterDto;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import com.digiwin.athena.executionengine.exception.BusinessException;
import com.digiwin.athena.executionengine.service.client.IDataCenterClient;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import com.digiwin.athena.executionengine.util.JsonResolverUtils;
import com.digiwin.athena.executionengine.util.LogUtils;
import com.digiwin.athena.smartdata.sdk.config.DatasourceUrl;
import java.util.Collection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="engineDataCenterClient")
public class DataCenterClient
implements IDataCenterClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataCenterClient.class);

    @Override
    public JSONArray getDataCenterData(DataCenterDto dataCenterDto) {
        JSONArray list = new JSONArray();
        int pageNo = 1;
        long startTime = System.currentTimeMillis();
        try {
            while (true) {
                Integer total;
                JSONObject dataNode;
                dataCenterDto.setPageNo(pageNo);
                JSONObject data = this.doQuery(dataCenterDto);
                if (data != null && !data.isEmpty() && (dataNode = data.getJSONObject("data")) != null && (total = Integer.valueOf(Integer.parseInt(dataNode.getString("totalCount")))) != 0) {
                    if (total >= 150000) {
                        throw new BusinessException(ErrorCodeEnum.ACTION_PULLING_DATA_OVERFLOW);
                    }
                    list.addAll((Collection)dataNode.getJSONArray("list"));
                    if (list.size() < total) {
                        ++pageNo;
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u8c03\u7528\u6570\u636e\u4e2d\u53f0\u67e5\u8be2\u5f02\u5e38\uff0cmodelCode\uff1a%s,\u67e5\u8be2schema:%s", dataCenterDto.getModelCode(), list.size(), dataCenterDto.getQuerySchema()));
        }
        long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.info(String.format("modelCode\uff1a%s\uff0c\u67e5\u8be2\u8017\u65f6:%sms\uff0c\u67e5\u8be2\u7b14\u6570:%s,\u67e5\u8be2schema:%s", dataCenterDto.getModelCode(), timeTaken, list.size(), dataCenterDto.getQuerySchema()));
        LogUtils.buildAgileLog("executeSqlAction", LogUtils.SUCCESS, "modelId:" + dataCenterDto.getModelId() + "\uff0c\u67e5\u8be2\u65b9\u6848:" + dataCenterDto.getQuerySchema(), "\u6570\u636e\u7b14\u6570\uff1a" + list.size(), "");
        return list;
    }

    private JSONObject doQuery(DataCenterDto dataCenterDto) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("token", dataCenterDto.getToken());
        headerMap.put("Content-Type", "application/json;charset=UTF-8");
        headerMap.put("routerKey", dataCenterDto.getRouterKey());
        headerMap.put("Accept", "application/json;charset=UTF-8");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orderColumn", dataCenterDto.getOrderColumn());
        param.put("pageNum", dataCenterDto.getPageNo());
        param.put("pageSize", dataCenterDto.getPageSize());
        param.put("modelId", dataCenterDto.getModelId());
        param.put("modelCode", dataCenterDto.getModelCode());
        param.put("totalEnable", true);
        param.put("queryInfo", dataCenterDto.getQuerySchema());
        String jsonParam = JsonResolverUtils.toJsonString(param);
        String httpRespContent = HttpClientUtils.doPost(DatasourceUrl.dcpUrl + "/api/ddl/data-platform/api/datasets", headerMap, jsonParam);
        return JSONObject.parseObject((String)httpRespContent);
    }
}

