/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.service.client.IIAMClient;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="engineIAMClient")
public class IAMClient
implements IIAMClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(IAMClient.class);

    @Override
    public JSONObject getUserInfoByToken(String token, boolean withEmp) {
        try {
            ServiceModel iamModel = new ServiceModel();
            iamModel.setToken(token);
            iamModel.setInvokeURL("/api/iam/v2/user/current?withEmp=" + withEmp);
            iamModel.setRequestMethod(DWRequestMethod.GET);
            iamModel.setApplicationToken(ModuleProperty.APP_TOKEN_VALUE);
            HttpResponseModel responseModel = (HttpResponseModel)IAMService.invoke((ServiceModel)iamModel);
            if (200 == responseModel.getHttpStatusCode()) {
                return JSON.parseObject((String)responseModel.getResponseBody());
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("agiledata_%s_getUserInfoByToken:%s ", "IAMClient", e));
        }
        return null;
    }
}

