/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.analyzer.impl;

import com.digiwin.athena.executionengine.core.container.SolutionStepContext;
import com.digiwin.athena.executionengine.model.input.SolutinStep.DatasetObject;
import com.digiwin.athena.executionengine.model.input.SolutinStep.SolutionStep;
import com.digiwin.athena.executionengine.service.facade.analyzer.ISolutionStepAnalyzer;
import com.digiwin.athena.executionengine.service.facade.execution.impl.SolutionStepExecutionFacade;
import com.digiwin.athena.executionengine.util.ContextUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="datasetObjectStep")
public class DatasetObjectSolutionStepAnalyzer
implements ISolutionStepAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetObjectSolutionStepAnalyzer.class);

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, ISolutionStepAnalyzer nextStep, SolutionStepContext context) {
    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, SolutionStepContext context) {
        DatasetObject datasetObject = solutionStep.getDatasetObject();
        String strStepIndex = stepIndex + "-" + solutionStep.getAlias();
        LOGGER.info("datasetObjectStep\u5f00\u59cb\u6267\u884cdatasetObject==null:{}", (Object)(datasetObject == null ? "true" : "false"));
        String datasetType = datasetObject.getDatasetType();
        if (datasetObject != null) {
            if ("metric".equalsIgnoreCase(datasetType) || "metricDataset".equalsIgnoreCase(datasetType) || "dataset".equals(datasetType)) {
                Object data = SolutionStepExecutionFacade.getMetricData(datasetObject.getAlias());
                if (data != null) {
                    Map<String, Object> dataMap = SolutionStepExecutionFacade.getTransDataMap();
                    if (dataMap != null) {
                        dataMap.put(strStepIndex, data);
                    } else {
                        dataMap = new HashMap<String, Object>();
                        dataMap.put(strStepIndex, data);
                    }
                    SolutionStepExecutionFacade.setTransDataMap(dataMap);
                }
            } else if ("step".equals(datasetObject.getDatasetType())) {
                Map<String, Object> dataMap = SolutionStepExecutionFacade.getTransDataMap();
                if (dataMap != null && dataMap.containsKey(datasetObject.getStep())) {
                    dataMap.put(strStepIndex, dataMap.get(datasetObject.getStep()));
                }
            } else if ("subQuery".equals(datasetObject.getDatasetType())) {
                datasetObject.getSubQuery().setAlias(solutionStep.getAlias());
                this.executeStep(datasetObject.getSubQuery(), stepIndex, context);
            }
        }
        if (solutionStep.getJoin() != null && CollectionUtils.isNotEmpty(solutionStep.getJoin())) {
            ISolutionStepAnalyzer joinStep = (ISolutionStepAnalyzer)ContextUtils.getBean("joinStep", new Object[0]);
            joinStep.executeStep(solutionStep, stepIndex, context);
        } else if (solutionStep.getFilter() != null && CollectionUtils.isNotEmpty(solutionStep.getFilter().getChildren())) {
            ISolutionStepAnalyzer filterStep = (ISolutionStepAnalyzer)ContextUtils.getBean("filterStep", new Object[0]);
            filterStep.executeStep(solutionStep, stepIndex, context);
        } else {
            ISolutionStepAnalyzer selectStep = (ISolutionStepAnalyzer)ContextUtils.getBean("selectStep", new Object[0]);
            selectStep.executeStep(solutionStep, stepIndex, context);
        }
    }
}

