/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.analyzer.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.core.container.SolutionStepContext;
import com.digiwin.athena.executionengine.model.input.SolutinStep.SolutionStep;
import com.digiwin.athena.executionengine.model.input.SolutinStep.Union;
import com.digiwin.athena.executionengine.service.facade.analyzer.ISolutionStepAnalyzer;
import com.digiwin.athena.executionengine.service.facade.analyzer.impl.DatasetObjectSolutionStepAnalyzer;
import com.digiwin.athena.executionengine.service.facade.convert.trans.ITransDefinitionConvertor;
import com.digiwin.athena.executionengine.service.facade.execution.impl.SolutionStepExecutionFacade;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.trans.TransEngine;
import com.digiwin.athena.executionengine.util.ContextUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="unionStep")
public class UnionSolutionStepAnalyzer
implements ISolutionStepAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnionSolutionStepAnalyzer.class);
    private ITransDefinitionConvertor transDefinitionConvertor;

    @Autowired
    public void setITransDefinitionConvertor(ITransDefinitionConvertor transDefinitionConvertor) {
        this.transDefinitionConvertor = transDefinitionConvertor;
    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, ISolutionStepAnalyzer nextStep, SolutionStepContext context) {
    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, SolutionStepContext context) {
        String dataKey = stepIndex + "-" + solutionStep.getAlias();
        Object leftData = SolutionStepExecutionFacade.getTransDataMap() != null && SolutionStepExecutionFacade.getTransDataMap().containsKey(dataKey) ? SolutionStepExecutionFacade.getTransDataMap().get(dataKey) : null;
        LOGGER.info("unionStep\u5f00\u59cb\u6267\u884cleftData==null:{}", (Object)(leftData == null ? "true" : "false"));
        if (leftData != null) {
            if (CollectionUtils.isNotEmpty(solutionStep.getUnion())) {
                for (Union union : solutionStep.getUnion()) {
                    DatasetObjectSolutionStepAnalyzer datasetObjectSolutionStepAnalyzer = (DatasetObjectSolutionStepAnalyzer)ContextUtils.getBean("datasetObjectStep", new Object[0]);
                    datasetObjectSolutionStepAnalyzer.executeStep(union.getSubQuery(), stepIndex, context);
                    Map<String, Object> transDataMap = SolutionStepExecutionFacade.getTransDataMap();
                    String key = stepIndex + "-" + union.getSubQuery().getAlias();
                    if (transDataMap == null || !transDataMap.containsKey(key)) continue;
                    Object unionData = transDataMap.get(key);
                    HashMap<String, Object> dataMap = new HashMap<String, Object>();
                    dataMap.put(dataKey, SolutionStepExecutionFacade.getTransDataMap().get(dataKey));
                    dataMap.put(key, unionData);
                    JSONObject criteriaDefinition = new JSONObject();
                    criteriaDefinition.put("technique", (Object)"union");
                    JSONObject jsonObject = this.transDefinitionConvertor.convert(criteriaDefinition);
                    LOGGER.info("unionStep\u6267\u884ctrans\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
                    TransDataManger transDataManger = new TransDataManger(jsonObject, dataMap, context.getTenantId(), context.getEocMap(), context.getToken());
                    TransEngine transEngine = ContextUtils.getBean(TransEngine.class, new Object[0]);
                    Object resultData = transEngine.runEngine(transDataManger);
                    SolutionStepExecutionFacade.getTransDataMap().put(dataKey, resultData);
                }
            }
            SolutionStepExecutionFacade.getTransDataMap().put(solutionStep.getAlias(), SolutionStepExecutionFacade.getTransDataMap().get(dataKey));
            SolutionStepExecutionFacade.getTransDataMap().remove(dataKey);
        }
    }
}

