/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.data.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.core.container.SolutionStepContext;
import com.digiwin.athena.executionengine.model.DataDescription;
import com.digiwin.athena.executionengine.model.input.InputParamModule;
import com.digiwin.athena.executionengine.model.input.InputParamModuleBuilder;
import com.digiwin.athena.executionengine.model.solutionStep.SolutionStepMetric;
import com.digiwin.athena.executionengine.service.facade.data.IScraper;
import com.digiwin.athena.executionengine.service.facade.data.impl.MetricScraper;
import com.digiwin.athena.executionengine.service.facade.execution.IExecutionFacade;
import com.digiwin.athena.executionengine.vo.MetricResultVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="metricDataset")
public class MetricDatasetScraper
implements IScraper {
    @Autowired
    private IExecutionFacade executionFacade;
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricScraper.class);

    @Override
    public MetricResultVo fetchData(SolutionStepMetric metric, SolutionStepContext context) {
        DataDescription dataDescription = new DataDescription();
        JSONObject dynamicSchema = new JSONObject();
        dynamicSchema.put("groupBy", CollectionUtils.isEmpty(metric.getGroupBy()) ? null : JSONArray.parseArray((String)JSONArray.toJSONString(metric.getGroupBy())));
        dynamicSchema.put("filter", metric.getFilter() == null || CollectionUtils.isEmpty(metric.getFilter().getChildren()) ? null : JSONObject.parseObject((String)JSONObject.toJSONString((Object)metric.getFilter())));
        dynamicSchema.put("having", metric.getHaving() == null || CollectionUtils.isEmpty(metric.getHaving().getChildren()) ? null : JSONObject.parseObject((String)JSONObject.toJSONString((Object)metric.getHaving())));
        dynamicSchema.put("computeList", metric.getComputeList() == null || metric.getComputeList().isEmpty() ? null : metric.getComputeList());
        dynamicSchema.put("sort", CollectionUtils.isEmpty(metric.getSort()) ? null : JSONArray.parseArray((String)JSONObject.toJSONString(metric.getSort())));
        dataDescription.setDynamicSchema(dynamicSchema);
        dataDescription.setProductLineRows(context.getPermissions() == null || context.getPermissions().isEmpty() ? null : JSONArray.parseArray((String)JSONObject.toJSONString((Object)context.getPermissions().get("rows"))));
        dataDescription.setProductLineInfo(context.getProductLineInfo());
        dataDescription.setDataset(true);
        InputParamModuleBuilder inputParamModuleBuilder = new InputParamModuleBuilder().setActionId(metric.getMetric()).setEocMaps(context.getEocMaps()).setSysParam(context.getParam()).setTenantId(context.getTenantId()).setDataDescription(dataDescription).setRoles(context.getRoles());
        InputParamModule inputParam = new InputParamModule(inputParamModuleBuilder);
        LOGGER.info(String.format("agiledata_%s_\u53d6\u6307\u6807\u6570\u636e\u5165\u53c2:%s", "SolutionStepMetricAnalyzer.getMetricData", inputParam));
        return this.executionFacade.query(inputParam);
    }
}

