/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.execution.asyc;

import com.digiwin.athena.executionengine.constant.ResultStatusConstant;
import com.digiwin.athena.executionengine.service.facade.event.ActionEventPublisher;
import com.digiwin.athena.executionengine.service.facade.execution.asyc.AsyncTask;
import com.digiwin.athena.executionengine.service.facade.execution.asyc.IAsyncExecutor;
import com.digiwin.athena.executionengine.util.ThreadPoolUtils;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="engineAsyncExecutor")
public class AsyncExecutor
implements IAsyncExecutor {
    @Autowired
    private ActionEventPublisher actionEventPublisher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTask(AsyncTask task) {
        Class<AsyncExecutor> clazz = AsyncExecutor.class;
        synchronized (AsyncExecutor.class) {
            if (task.getActionParam().getActionState() != ResultStatusConstant.UN_EXECUTED.getCode()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            task.getActionParam().setActionState(ResultStatusConstant.EXECUTING.getCode());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            CompletableFuture.runAsync(() -> task.exec(), ThreadPoolUtils.getExecutorService()).thenRun(() -> this.actionEventPublisher.publishActionEvent(task.getActionParam().getActionId(), task.getExecuteContext()));
            return;
        }
    }
}

