/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.mapping.param;

import com.digiwin.athena.executionengine.component.param.ParamBase;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import com.digiwin.athena.executionengine.enumtype.ValueTypeEnum;
import com.digiwin.athena.executionengine.exception.BusinessException;
import com.digiwin.athena.executionengine.model.ParamElement;
import com.digiwin.athena.executionengine.model.ServiceResult;
import com.digiwin.athena.executionengine.service.facade.mapping.param.ConstructionUtils;
import com.digiwin.athena.executionengine.util.ExceptionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamMappingUtils {
    ExecuteContext context;
    String actionId;
    List<ParamBase> actionParams;
    ConstructionUtils constructionUtils;
    private static final Logger LOGGER = LoggerFactory.getLogger(ParamMappingUtils.class);

    public ParamMappingUtils(ExecuteContext context, String actionId) {
        this.context = context;
        this.actionId = actionId;
        this.actionParams = context.getActionParam(actionId).getParams();
        this.constructionUtils = new ConstructionUtils(this.context, this.actionParams);
    }

    private int calculateRootSize(Map<String, ParamBase> paramBaseList) {
        if (paramBaseList.size() == 1) {
            return 1;
        }
        HashSet<Integer> rootSizeSet = new HashSet<Integer>();
        int loopNum = 0;
        for (Map.Entry<String, ParamBase> paramBaseEntry : paramBaseList.entrySet()) {
            ParamBase paramBase = paramBaseEntry.getValue();
            if (!paramBase.isCollectionRoot(this.context.getDataMappingManager(), this.actionId)) continue;
            int rootSize = paramBase.getRootSize(this.context.getDataMappingManager(), this.actionId);
            rootSizeSet.add(rootSize);
            if (loopNum > 0 && rootSizeSet.size() > 1) {
                String srcActionId = paramBase.getSrcActionId(this.context);
                LOGGER.error("\u6784\u5efa\u9000\u51fa\uff01\u53c2\u6570\u591a\u6765\u6e90\u957f\u5ea6\u4e0d\u4e00\u81f4: actionId:{}, valueParam:{}", (Object)srcActionId, (Object)paramBase.getValue());
                break;
            }
            ++loopNum;
        }
        return rootSizeSet.size() > 1 ? -1 : rootSizeSet.size();
    }

    public ServiceResult mappingReqParam(List<Object> apiParams, List<ParamElement> requestParameters) {
        for (ParamElement paramElement : requestParameters) {
            Map<String, ParamBase> paramBaseMap = this.constructionUtils.getSrcParamBase(paramElement);
            if (MapUtils.isEmpty(paramBaseMap)) {
                LOGGER.info("\u5faa\u73afrequestParameters\u65f6\uff0c\u68c0\u67e5\u51faParamElement\u5bf9\u5e94\u7684\u6620\u5c04\u5173\u7cfb\u4e0d\u5b58\u5728,\u5373\u5c06continue,paramName:{}", (Object)paramElement.getParamName());
                continue;
            }
            if (!this.mappingRelationCheck(paramBaseMap, paramElement)) continue;
            int rootSize = this.calculateRootSize(paramBaseMap);
            if (rootSize < 0) {
                LOGGER.error("\u8ba1\u7b97\u591a\u6765\u6e90\u7684rootSize\u6570\u636e\u91cf\u4e0d\u76f8\u540c\uff0c\u68c0\u67e5\u6570\u636e");
                return new ServiceResult(false, "\u8ba1\u7b97\u591a\u6765\u6e90\u7684rootSize\u6570\u636e\u91cf\u4e0d\u76f8\u540c\uff0c\u68c0\u67e5\u6570\u636e");
            }
            Map<String, List<String>> pathInfoGroup = this.constructionUtils.getPathInfo(paramBaseMap, this.actionId);
            boolean isNeedConstructUpper = this.isNeedConstructUpper(paramElement, pathInfoGroup);
            if (!isNeedConstructUpper) {
                apiParams.add(this.assemble(paramElement));
                continue;
            }
            ArrayList<Object> paramList = new ArrayList<Object>();
            boolean constructResult = this.constructUpperLevel(paramList, paramElement, paramBaseMap, pathInfoGroup, 0);
            if (!constructResult) {
                return new ServiceResult(false, "\u4e0d\u540c\u6e90\u6570\u636e\uff0c\u5728\u540c\u5c42\u6b21\u7684\u6570\u91cf\u4e0d\u4e00\u81f4");
            }
            apiParams.add(paramList.size() > 1 ? paramList : paramList.get(0));
        }
        return new ServiceResult(true);
    }

    private boolean mappingRelationCheck(Map<String, ParamBase> paramBaseMap, ParamElement paramElement) {
        boolean pathExists = false;
        for (Map.Entry<String, ParamBase> entry : paramBaseMap.entrySet()) {
            ParamBase paramBase = entry.getValue();
            pathExists = paramBase.pathIsExistsInData(this.context.getDataMappingManager(), this.actionId, paramBase.getValue());
            if (pathExists || !paramElement.getIsRequired().booleanValue()) continue;
            throw ExceptionUtils.buildVerificationException(ErrorCodeEnum.MAPPING_RELATION_NOT_FOUND_IN_SOURCE_DATA, paramElement.getParamPath());
        }
        return pathExists;
    }

    private boolean isNeedConstructUpper(ParamElement paramElement, Map<String, List<String>> pathInfoGroup) {
        Map<String, ParamBase> paramBaseList = this.constructionUtils.getSrcParamBase(paramElement);
        for (Map.Entry<String, ParamBase> paramBaseEntry : paramBaseList.entrySet()) {
            ParamBase paramBase = paramBaseEntry.getValue();
            if (!paramBase.pathIsExistsInData(this.context.getDataMappingManager(), this.actionId, paramBase.getValue()) || !this.isComplexProperties(paramElement) || !paramBase.isObjectCollectionParam(this.context.getDataMappingManager(), this.actionId, paramBase.getValue())) continue;
            List<String> pathInfo = pathInfoGroup.get(this.constructionUtils.getMultipleSourceKey(paramBase));
            pathInfo.add(paramBase.getValue());
        }
        return this.isDataHaveCollection(pathInfoGroup);
    }

    private boolean isDataHaveCollection(Map<String, List<String>> pathInfoGroup) {
        for (Map.Entry<String, List<String>> pathInfoEntry : pathInfoGroup.entrySet()) {
            if (pathInfoEntry.getValue().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public List<Map<String, Object>> mergeApiData(List<Object> apiParamList) {
        return this.setApiData(apiParamList);
    }

    public List<Map<String, Object>> setApiData(List<Object> apiParamList) {
        int paramSize = this.getParamSize(apiParamList);
        ArrayList<Map<String, Object>> apiData = new ArrayList<Map<String, Object>>();
        if (paramSize == 0) {
            HashMap apiParam = new HashMap();
            for (Object apiParamData : apiParamList) {
                if (apiParamData instanceof List) continue;
                apiParam.putAll((Map)apiParamData);
            }
            if (!MapUtils.isEmpty(apiParam)) {
                apiData.add(apiParam);
            }
            return apiData;
        }
        for (int pos = 0; pos < paramSize; ++pos) {
            ArrayList<Object> deepApiParamList = new ArrayList<Object>();
            for (Object apiParam : apiParamList) {
                if (!(apiParam instanceof List)) {
                    deepApiParamList.add(apiParam);
                    continue;
                }
                if (CollectionUtils.isEmpty((Collection)((List)apiParam))) continue;
                if (((List)apiParam).get(0) instanceof Map) {
                    deepApiParamList.add(((List)apiParam).get(0));
                    continue;
                }
                if (pos > ((List)apiParam).size() - 1) {
                    throw new BusinessException(ErrorCodeEnum.SAME_LEVER_SIZE_DIFF.getCode(), ErrorCodeEnum.SAME_LEVER_SIZE_DIFF.getMessage());
                }
                deepApiParamList.add(((List)apiParam).get(pos));
            }
            apiData.addAll(this.setApiData(deepApiParamList));
        }
        return apiData;
    }

    private int getParamSize(List<Object> apiParamList) {
        int paramSize = 0;
        for (Object apiParam : apiParamList) {
            if (!(apiParam instanceof List) || paramSize != 0 && (paramSize == 0 || paramSize >= ((List)apiParam).size())) continue;
            paramSize = ((List)apiParam).size();
        }
        return paramSize;
    }

    private boolean isSameDataSizeInDifferentSource(Map<String, Integer> dataSizeInPathInfo) {
        int lastSize = 0;
        boolean isFirstRun = true;
        boolean isSameSize = true;
        for (Map.Entry<String, Integer> dataSizeInPathInfoEntry : dataSizeInPathInfo.entrySet()) {
            int size = dataSizeInPathInfoEntry.getValue();
            if (isFirstRun) {
                isFirstRun = false;
                lastSize = size;
            }
            if (lastSize != size) {
                isSameSize = false;
                break;
            }
            lastSize = size;
        }
        return isSameSize;
    }

    private boolean constructUpperLevel(List<Object> parentList, ParamElement requestParameter, Map<String, ParamBase> paramBaseList, Map<String, List<String>> pathInfoGroup, int pos) {
        HashMap<String, Integer> dataSizeInPathInfo = new HashMap<String, Integer>();
        int pathLevel = 0;
        for (Map.Entry<String, ParamBase> paramEntry : paramBaseList.entrySet()) {
            List<String> pathList = pathInfoGroup.get(paramEntry.getKey());
            if (pathList.size() > pathLevel) {
                pathLevel = pathList.size();
            }
            ParamBase param = paramEntry.getValue();
            if (pos != 0 && pos >= pathList.size()) {
                return false;
            }
            int size = param.getPathDataSize(this.context.getDataMappingManager(), this.actionId, pathList.get(pos));
            dataSizeInPathInfo.put(param.getValue(), size);
        }
        if (!this.isSameDataSizeInDifferentSource(dataSizeInPathInfo)) {
            LOGGER.error("\u4e0d\u540c\u6e90\u6570\u636e\uff0c\u5728\u540c\u5c42\u6b21\u7684\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
            return false;
        }
        int sourceSize = this.checkAndGetMultiSrcSizeOnSameLevel(pathInfoGroup, paramBaseList, pos);
        if (sourceSize < 0) {
            return false;
        }
        for (int i = 0; i < sourceSize; ++i) {
            ArrayList<Object> list = new ArrayList<Object>();
            parentList.add(list);
            for (Map.Entry<String, ParamBase> paramEntry : paramBaseList.entrySet()) {
                List<String> pathList = pathInfoGroup.get(paramEntry.getKey());
                this.constructionUtils.setJsonPath(paramEntry.getValue(), this.actionId, pathList.get(pos), i);
            }
            if (!(pos == pathLevel - 1 || pathLevel == 0 ? !this.buildLowerLevel(list, requestParameter) : !this.constructUpperLevel(list, requestParameter, paramBaseList, pathInfoGroup, pos + 1))) continue;
            return false;
        }
        return true;
    }

    private int getDataSize(Map<String, List<String>> pathInfoMap, ParamBase paramBase, int pos) {
        List<String> pathList = pathInfoMap.get(this.constructionUtils.getMultipleSourceKey(paramBase));
        return paramBase.getPathDataSize(this.context.getDataMappingManager(), this.actionId, pathList.get(pos));
    }

    private boolean assembleSimpleProperty(HashMap<String, Object> param, ParamElement requestParameter) {
        Map<String, ParamBase> paramBaseMap = this.constructionUtils.getSrcParamBase(requestParameter);
        if (MapUtils.isEmpty(paramBaseMap)) {
            return false;
        }
        String[] keys = paramBaseMap.keySet().toArray(new String[0]);
        if (keys.length == 0) {
            return false;
        }
        ParamBase paramBase = paramBaseMap.get(keys[0]);
        if (paramBase == null) {
            if (requestParameter.getIsRequired().booleanValue()) {
                throw ExceptionUtils.buildVerificationException(ErrorCodeEnum.REQUIRE_FIELD_NONE_MAPPING_RELATION, requestParameter.getParamPath());
            }
        } else {
            Object elementValue = this.getValueByParamBase(paramBase);
            if (requestParameter.getIsRequired().booleanValue()) {
                if (elementValue == null) {
                    throw ExceptionUtils.buildVerificationException(ErrorCodeEnum.REQUIRE_FIELD_NONE_DATA, this.buildExceptionInfo(requestParameter.getActionId(), paramBase));
                }
                param.put(requestParameter.getParamName(), elementValue);
            } else {
                param.put(requestParameter.getParamName(), elementValue);
            }
        }
        return true;
    }

    private String buildExceptionInfo(String actionId, ParamBase paramBase) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("actionId:");
        sBuilder.append(actionId);
        sBuilder.append(";name:");
        sBuilder.append(paramBase.getName());
        sBuilder.append(";value:");
        sBuilder.append(paramBase.getValue());
        return sBuilder.toString();
    }

    private boolean buildLowerLevel(List<Object> lastLevelList, ParamElement requestParameter) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (this.isSingleProperties(requestParameter) || this.isSingleCollectionProperties(requestParameter)) {
            if (!this.assembleSimpleProperty(param, requestParameter)) {
                return false;
            }
            lastLevelList.add(param);
        } else if (this.isComplexProperties(requestParameter)) {
            HashMap<String, Object> paramItem = new HashMap<String, Object>();
            param.put(requestParameter.getParamName(), paramItem);
            boolean result = this.assembleComplex(paramItem, requestParameter.getChildElements(), requestParameter);
            if (!result) {
                return false;
            }
            lastLevelList.add(param);
        } else if (this.isObjectCollectionProperties(requestParameter)) {
            ArrayList<HashMap<String, Object>> paraList = new ArrayList<HashMap<String, Object>>();
            param.put(requestParameter.getParamName(), paraList);
            Map<String, ParamBase> paramBaseList = this.constructionUtils.getSrcParamBase(requestParameter);
            int compareSize = 0;
            boolean isCompareSizeInCollectionPath = false;
            for (Map.Entry<String, ParamBase> paramBaseEntry : paramBaseList.entrySet()) {
                int collectionLevelInPath;
                boolean isPathSame;
                ParamBase paramBase = paramBaseEntry.getValue();
                int size = paramBase.getDataSize(this.context.getDataMappingManager(), this.actionId, paramBase.getValue(), this.constructionUtils.getJsonPath(paramBase, this.actionId));
                if (compareSize <= 0) {
                    compareSize = size;
                    if (paramBase.countCollectionInPath(this.context.getDataMappingManager(), this.actionId, paramBase.getValue()) <= 0) continue;
                    isCompareSizeInCollectionPath = true;
                    continue;
                }
                if (compareSize != size) {
                    return false;
                }
                if (size != 1 || !(isPathSame = (collectionLevelInPath = paramBase.countCollectionInPath(this.context.getDataMappingManager(), this.actionId, paramBase.getValue())) > 0 && !isCompareSizeInCollectionPath || collectionLevelInPath == 0 && isCompareSizeInCollectionPath)) continue;
                LOGGER.error("\u8def\u5f84\u7ed3\u6784\u4e0d\u540c\uff0c\u867d\u7136\u6570\u636e\u91cf\u90fd\u662f1\uff0c\u4f46\u662f\u4f9d\u7136\u4e0d\u8ba4\u4e3a\u662f\u5408\u6cd5\u7ed3\u6784\uff1aparamBase.name:{}", (Object)paramBase.getName());
                return false;
            }
            for (int i = 0; i < compareSize; ++i) {
                this.setDataSrcJsonPath(paramBaseList, i);
                HashMap<String, Object> paramItem = new HashMap<String, Object>();
                boolean isSuccess = this.assembleComplex(paramItem, requestParameter.getChildElements(), requestParameter);
                if (!isSuccess) {
                    return false;
                }
                if (!MapUtils.isNotEmpty(paramItem)) continue;
                paraList.add(paramItem);
            }
            this.handleIsRequire(lastLevelList, requestParameter, param, paraList);
        }
        return true;
    }

    private void setDataSrcJsonPath(Map<String, ParamBase> paramBaseList, int i) {
        for (Map.Entry<String, ParamBase> paramBaseEntry : paramBaseList.entrySet()) {
            this.constructionUtils.setJsonPath(paramBaseEntry.getValue(), this.actionId, paramBaseEntry.getValue().getValue(), i);
        }
    }

    private int checkAndGetMultiSrcSizeOnSameLevel(Map<String, List<String>> pathInfoGroup, Map<String, ParamBase> paramBaseList, int pos) {
        int compareSize = 0;
        boolean isCompareSizeInCollectionPath = false;
        for (Map.Entry<String, ParamBase> paramBaseEntry : paramBaseList.entrySet()) {
            int collectionCountInPath;
            boolean isPathSame;
            ParamBase paramBase = paramBaseEntry.getValue();
            int size = this.getDataSize(pathInfoGroup, paramBase, pos);
            if (compareSize <= 0) {
                compareSize = size;
                if (paramBase.countCollectionInPath(this.context.getDataMappingManager(), this.actionId, paramBase.getValue()) <= 0) continue;
                isCompareSizeInCollectionPath = true;
                continue;
            }
            if (compareSize != size) {
                compareSize = -1;
                return compareSize;
            }
            if (size != 1 || !(isPathSame = (collectionCountInPath = paramBase.countCollectionInPath(this.context.getDataMappingManager(), this.actionId, paramBase.getValue())) > 0 && !isCompareSizeInCollectionPath || collectionCountInPath == 0 && isCompareSizeInCollectionPath)) continue;
            LOGGER.error("\u8def\u5f84\u7ed3\u6784\u4e0d\u540c\uff0c\u867d\u7136\u6570\u636e\u91cf\u90fd\u662f1\uff0c\u4f46\u662f\u4f9d\u7136\u4e0d\u8ba4\u4e3a\u662f\u5408\u6cd5\u7ed3\u6784\uff1aparamBase.name:{}", (Object)paramBase.getName());
            compareSize = -1;
            return compareSize;
        }
        return compareSize;
    }

    private void handleIsRequire(List<Object> lastLevelList, ParamElement requestParameter, HashMap<String, Object> param, List<HashMap<String, Object>> paraList) {
        if (requestParameter.getIsRequired().booleanValue()) {
            if (MapUtils.isEmpty(param)) {
                throw ExceptionUtils.buildVerificationException(ErrorCodeEnum.REQUIRE_FIELD_NONE_DATA, requestParameter.getParamPath());
            }
            if (param.get(requestParameter.getParamName()) instanceof List && CollectionUtils.isEmpty((Collection)((Collection)param.get(requestParameter.getParamName())))) {
                throw ExceptionUtils.buildVerificationException(ErrorCodeEnum.REQUIRE_FIELD_NONE_DATA, requestParameter.getParamPath());
            }
            lastLevelList.add(param);
        } else if (paraList.size() > 0) {
            lastLevelList.add(param);
        }
    }

    private Object assemble(ParamElement requestParameter) {
        ArrayList<Object> lastLevelList = new ArrayList<Object>();
        this.buildLowerLevel(lastLevelList, requestParameter);
        if (lastLevelList.size() > 0) {
            return lastLevelList.get(0);
        }
        return lastLevelList;
    }

    private boolean assembleComplex(HashMap<String, Object> param, List<ParamElement> childElements, ParamElement requestParameter) {
        boolean isSuccess = true;
        Map<String, ParamBase> parentParamBaseList = this.constructionUtils.getSrcParamBase(requestParameter);
        for (ParamElement childElement : childElements) {
            boolean result;
            Map<String, ParamBase> paramBaseMap = this.constructionUtils.getSrcParamBase(childElement);
            if (MapUtils.isEmpty(paramBaseMap)) {
                LOGGER.debug("\u5411\u4e0b\u6784\u5efa\u65f6\uff0c\u68c0\u67e5\u51fachildElement\u5bf9\u5e94\u7684\u6620\u5c04\u5173\u7cfb\u4e0d\u5b58\u5728,\u5373\u5c06continue,paramName:{}", (Object)childElement.getParamName());
                continue;
            }
            if (!this.mappingRelationCheck(paramBaseMap, childElement)) continue;
            if (this.isSingleProperties(childElement) || this.isSingleCollectionProperties(childElement)) {
                isSuccess = this.assembleSimpleProperty(param, childElement);
                if (isSuccess) continue;
                break;
            }
            if (this.isComplexProperties(childElement)) {
                HashMap<String, Object> paramItem = new HashMap<String, Object>();
                param.put(childElement.getParamName(), paramItem);
                isSuccess = this.assembleComplex(paramItem, childElement.getChildElements(), childElement);
                if (isSuccess) continue;
                break;
            }
            if (!this.isObjectCollectionProperties(childElement) || (result = this.assembleCollection(paramBaseMap, parentParamBaseList, childElement, param))) continue;
            return false;
        }
        return isSuccess;
    }

    private boolean assembleCollection(Map<String, ParamBase> paramBaseList, Map<String, ParamBase> parentParamBaseList, ParamElement childElement, HashMap<String, Object> param) {
        int compareSize = 0;
        boolean isCompareSizeInCollectionPath = false;
        for (Map.Entry<String, ParamBase> paramBaseEntry : paramBaseList.entrySet()) {
            int collectionLevelInPath;
            boolean isPathSame;
            ParamBase paramBase = paramBaseEntry.getValue();
            ParamBase parentParamBase = this.constructionUtils.getRealParentParamBase(paramBase, parentParamBaseList);
            int size = paramBase.getPathDataSize(this.context.getDataMappingManager(), this.actionId, paramBase.getValue(), this.constructionUtils.getJsonPath(parentParamBase, this.actionId));
            if (compareSize <= 0) {
                compareSize = size;
                if (paramBase.countCollectionInPath(this.context.getDataMappingManager(), this.actionId, paramBase.getValue()) <= 0) continue;
                isCompareSizeInCollectionPath = true;
                continue;
            }
            if (compareSize != size) {
                return false;
            }
            if (size != 1 || !(isPathSame = (collectionLevelInPath = paramBase.countCollectionInPath(this.context.getDataMappingManager(), this.actionId, paramBase.getValue())) > 0 && !isCompareSizeInCollectionPath || collectionLevelInPath == 0 && isCompareSizeInCollectionPath)) continue;
            LOGGER.error("\u8def\u5f84\u7ed3\u6784\u4e0d\u540c\uff0c\u867d\u7136\u6570\u636e\u91cf\u90fd\u662f1\uff0c\u4f46\u662f\u4f9d\u7136\u4e0d\u8ba4\u4e3a\u662f\u5408\u6cd5\u7ed3\u6784\uff1aparamBase.name:{}", (Object)paramBase.getName());
            return false;
        }
        ArrayList<HashMap<String, Object>> paraList = new ArrayList<HashMap<String, Object>>();
        for (int i = 0; i < compareSize; ++i) {
            HashMap<String, Object> paramItem = new HashMap<String, Object>();
            this.setEveryParamJsonPath(paramBaseList, i);
            boolean isSuccess = this.assembleComplex(paramItem, childElement.getChildElements(), childElement);
            if (!isSuccess) {
                return false;
            }
            paraList.add(paramItem);
        }
        param.put(childElement.getParamName(), paraList);
        return true;
    }

    private void setEveryParamJsonPath(Map<String, ParamBase> paramBaseList, int pos) {
        for (Map.Entry<String, ParamBase> paramBaseEntry : paramBaseList.entrySet()) {
            this.constructionUtils.setJsonPath(paramBaseEntry.getValue(), this.actionId, paramBaseEntry.getValue().getValue(), pos);
        }
    }

    private Object getValueByParamBase(ParamBase paramBase) {
        String concreteCollectionPath = this.constructionUtils.getJsonPath(paramBase, this.actionId);
        return paramBase.getData(this.context, concreteCollectionPath);
    }

    private boolean isSingleProperties(ParamElement element) {
        return ValueTypeEnum.OBJECT != element.getValueType() && element.getArray() == false;
    }

    private boolean isSingleCollectionProperties(ParamElement element) {
        return ValueTypeEnum.OBJECT != element.getValueType() && element.getArray() != false;
    }

    private boolean isObjectCollectionProperties(ParamElement element) {
        return ValueTypeEnum.OBJECT == element.getValueType() && element.getArray() != false;
    }

    private boolean isComplexProperties(ParamElement element) {
        return ValueTypeEnum.OBJECT == element.getValueType() && element.getArray() == false;
    }
}

