/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.schema.datacenter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.CommonConstant;
import com.digiwin.athena.executionengine.dto.schema.LeftDto;
import com.digiwin.athena.executionengine.dto.schema.RightDto;
import com.digiwin.athena.executionengine.dto.schema.SchemaTransDto;
import com.digiwin.athena.executionengine.model.action.DataCenterFilterNode;
import com.digiwin.athena.executionengine.service.facade.schema.AbstractSchemaConvertor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DataCenterFilterConvertor
extends AbstractSchemaConvertor {
    @Override
    public void convert(SchemaTransDto schemaTransDto) {
        if (schemaTransDto.getDynamicSchema() == null) {
            return;
        }
        JSONObject filterObj = (JSONObject)schemaTransDto.getDynamicSchema();
        JSONObject computeObj = schemaTransDto.getComputeObj();
        JSONObject querySchema = schemaTransDto.getQuerySchema();
        JSONObject mappingFields = (JSONObject)schemaTransDto.getReqData();
        if (MapUtils.isEmpty((Map)filterObj)) {
            return;
        }
        DataCenterFilterNode filterNode = this.processFilter(filterObj, computeObj, mappingFields);
        if (filterNode != null) {
            JSONObject filter = new JSONObject();
            JSONArray children = new JSONArray();
            filter.put("logical", (Object)"and");
            filter.put("children", (Object)children);
            if (MapUtils.isNotEmpty((Map)querySchema.getJSONObject("filter"))) {
                children.add((Object)querySchema.getJSONObject("filter"));
            }
            children.add(JSONObject.toJSON((Object)filterNode));
            querySchema.put("filter", (Object)filter);
        }
    }

    private DataCenterFilterNode processFilter(JSONObject filter, JSONObject computeObj, JSONObject mappingFields) {
        DataCenterFilterNode filterNode = new DataCenterFilterNode();
        String logic = filter.getString("logic");
        if (filter.size() > 2) {
            LeftDto leftDto = this.getLeftDto(filter, computeObj);
            RightDto rightDto = this.getRightDto(filter, computeObj);
            if (leftDto == null || rightDto == null) {
                return null;
            }
            filterNode.setLeftValue(mappingFields.getString(leftDto.getLeftField()));
            filterNode.setOperator(CommonConstant.DATA_CENTER_FILTER_TYPE_COMPARISON_MAP.get(filter.getString("operator")));
            filterNode.setRightValue(rightDto.getRightValue());
            filterNode.setRightType(rightDto.getFilterRightType());
            if (StringUtils.isNotEmpty((CharSequence)leftDto.getFunction())) {
                filterNode.setFieldFunctionFlag(true);
                filterNode.setFieldFunctionType(leftDto.getFunction());
                filterNode.setFunctionParams(leftDto.getFunctionParams());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)filter.getJSONArray("children"))) {
            filterNode.setLogical(logic);
            JSONArray children = filter.getJSONArray("children");
            for (int i = 0; i < children.size(); ++i) {
                JSONObject child = children.getJSONObject(i);
                DataCenterFilterNode childNode = this.processFilter(child, computeObj, mappingFields);
                if (childNode == null) continue;
                filterNode.getChildren().add(childNode);
            }
        }
        return filterNode;
    }

    private RightDto getRightDto(JSONObject filter, JSONObject computeObj) {
        JSONArray rights = filter.getJSONArray("right");
        if (CollectionUtils.isEmpty((Collection)rights)) {
            return null;
        }
        JSONObject rightObj = rights.getJSONObject(0);
        JSONObject dataObject = rightObj.getJSONObject("dataObject");
        if (MapUtils.isEmpty((Map)dataObject)) {
            return null;
        }
        String contentType = dataObject.getString("contentType");
        if (!"const".equals(contentType)) {
            return null;
        }
        List collect = rights.stream().map(item -> (JSONObject)item).map(obj -> obj.getJSONObject("dataObject").getString("content")).collect(Collectors.toList());
        String rightValue = collect.stream().collect(Collectors.joining(","));
        return new RightDto(rightValue, contentType);
    }

    private LeftDto getLeftDto(JSONObject filter, JSONObject computeObj) {
        JSONObject left = filter.getJSONObject("left");
        String contentType = left.getString("contentType");
        String content = left.getString("content");
        if ("calculate".equals(contentType)) {
            JSONArray computeList = computeObj.getJSONArray(content);
            JSONObject compute = computeList.getJSONObject(0);
            String field = compute.getJSONArray("params").getJSONObject(0).getString("content");
            String function = compute.getJSONArray("params").getJSONObject(1).getString("contentType");
            String type = compute.getJSONArray("params").getJSONObject(1).getString("content");
            return new LeftDto(field, contentType, function.toLowerCase(), type);
        }
        return new LeftDto(content, contentType);
    }
}

