/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.trans.util;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.model.trans.AddColumnElement;
import com.digiwin.athena.executionengine.model.trans.CollectCondition;
import com.digiwin.athena.executionengine.model.trans.FilterItem;
import com.digiwin.athena.executionengine.model.trans.JoinSelectElement;
import com.digiwin.athena.executionengine.model.trans.NumberRangeRuleElement;
import com.digiwin.athena.executionengine.model.trans.OrderElement;
import com.digiwin.athena.executionengine.model.trans.RuntimeInfoElement;
import com.digiwin.athena.executionengine.model.trans.Statistic;
import com.digiwin.athena.executionengine.model.trans.StepElement;
import com.digiwin.athena.executionengine.model.trans.components.CalculateRuleDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransAnalysisUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransAnalysisUtils.class);

    public static String getVersion(JSONObject jsonObject) {
        try {
            String version = jsonObject.getString("version");
            if (version == null) {
                return "1";
            }
            return version;
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790rule\u8bfb\u53d6version:{},\u5f02\u5e38:{}", (Object)jsonObject, (Object)e);
            return null;
        }
    }

    public static List<StepElement> parseStep(JSONObject jsonObject) {
        try {
            List ruleList = jsonObject.getJSONArray("step").toJavaList(JSONObject.class);
            if (CollectionUtils.isEmpty((Collection)ruleList)) {
                return null;
            }
            ArrayList<StepElement> dataElementList = new ArrayList<StepElement>();
            for (JSONObject ruleObj : ruleList) {
                StepElement stepElement = new StepElement();
                stepElement.setTechnique(ruleObj.getString("technique"));
                String stepName = ruleObj.getString("name");
                if (stepName.isEmpty()) {
                    LOGGER.error("\u89e3\u6790rule-step\u89c4\u5219\u5931\u8d25\uff0cstep name\u4e3a\u7a7a", (Object)stepName);
                    break;
                }
                stepElement.setName(stepName);
                if ("group".equals(stepElement.getTechnique())) {
                    dataElementList.add(TransAnalysisUtils.parseGroup(ruleObj, stepElement));
                } else if ("filter".equals(stepElement.getTechnique())) {
                    dataElementList.add(TransAnalysisUtils.parseFilter(ruleObj, stepElement));
                } else if ("polymerize".equals(stepElement.getTechnique())) {
                    dataElementList.add(TransAnalysisUtils.parseCollect(ruleObj, stepElement));
                } else if ("mechanism".equals(stepElement.getTechnique())) {
                    dataElementList.add(TransAnalysisUtils.parseMechanism(ruleObj, stepElement));
                } else if ("distinct".equals(stepElement.getTechnique())) {
                    dataElementList.add(TransAnalysisUtils.parseDistinct(ruleObj, stepElement));
                } else if ("calculate".equals(stepElement.getTechnique())) {
                    dataElementList.add(TransAnalysisUtils.parseCalculate(ruleObj, stepElement));
                } else if ("input".equals(stepElement.getTechnique())) {
                    dataElementList.add(TransAnalysisUtils.parseInput(ruleObj, stepElement));
                } else if ("join".equals(stepElement.getTechnique())) {
                    dataElementList.add(TransAnalysisUtils.parseJoin(ruleObj, stepElement));
                } else if ("spread".equals(stepElement.getTechnique())) {
                    dataElementList.add(stepElement);
                } else if ("numberRange".equals(stepElement.getTechnique())) {
                    dataElementList.add(TransAnalysisUtils.parseNumberRange(ruleObj, stepElement));
                } else if ("getRuntimeInfo".equals(stepElement.getTechnique())) {
                    dataElementList.add(TransAnalysisUtils.parseGetRuntimeInfo(ruleObj, stepElement));
                } else if ("addColumn".equals(stepElement.getTechnique())) {
                    dataElementList.add(TransAnalysisUtils.parseAddColumn(ruleObj, stepElement));
                } else if ("truncateKey".equals(stepElement.getTechnique())) {
                    dataElementList.add(stepElement);
                } else if ("chooseColumn".equals(stepElement.getTechnique())) {
                    stepElement.setFields((List<String>)ruleObj.getJSONArray("fields"));
                    stepElement.setType(ruleObj.getString("type"));
                    dataElementList.add(stepElement);
                } else if ("union".equalsIgnoreCase(stepElement.getTechnique())) {
                    stepElement.setType(ruleObj.getString("type"));
                    String dataLeft = ruleObj.getString("data_lt");
                    String dataRight = ruleObj.getString("data_rt");
                    stepElement.setDataLt(dataLeft);
                    stepElement.setDataRt(dataRight);
                    dataElementList.add(stepElement);
                } else {
                    dataElementList.add(stepElement);
                }
                if (stepElement != null) continue;
                LOGGER.error("\u89e3\u6790rule-step\u89c4\u5219\u5931\u8d25\uff0cstep name: {}", (Object)stepName);
                break;
            }
            return dataElementList;
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790rule-step\u89c4\u5219:{},\u5f02\u5e38:{}", (Object)jsonObject, (Object)e);
            return null;
        }
    }

    private static StepElement parseAddColumn(JSONObject ruleObject, StepElement stepElement) {
        List addColumnRules = ruleObject.getJSONArray("rule").toJavaList(JSONObject.class);
        ArrayList<AddColumnElement> rules = new ArrayList<AddColumnElement>();
        for (JSONObject ruleObj : addColumnRules) {
            AddColumnElement addColumnElement = new AddColumnElement();
            Object value = ruleObj.get((Object)"value");
            Object valueType = ruleObj.get((Object)"value_type");
            Object type = ruleObj.get((Object)"type");
            Object newField = ruleObj.get((Object)"newField");
            addColumnElement.setNewField(newField == null ? "" : String.valueOf(newField));
            addColumnElement.setType(type == null ? "" : String.valueOf(type));
            addColumnElement.setValueType(valueType == null ? "" : String.valueOf(valueType));
            addColumnElement.setValue(value == null ? null : String.valueOf(value));
            rules.add(addColumnElement);
        }
        stepElement.setRules(rules);
        return stepElement;
    }

    public static List<OrderElement> parseOrder(JSONObject jsonObject) {
        try {
            List orderList = jsonObject.getJSONArray("order").toJavaList(JSONObject.class);
            if (CollectionUtils.isEmpty((Collection)orderList)) {
                return null;
            }
            ArrayList<OrderElement> orderElementList = new ArrayList<OrderElement>();
            for (JSONObject orderObj : orderList) {
                OrderElement orderElement = new OrderElement();
                orderElement.setFrom(orderObj.getString("from"));
                orderElement.setTo(orderObj.getString("to"));
                orderElementList.add(orderElement);
            }
            return orderElementList;
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790rule\u89c4\u5219:{},\u5f02\u5e38:{}", (Object)jsonObject, (Object)e);
            return null;
        }
    }

    private static StepElement parseJoin(JSONObject ruleObject, StepElement joinStepElement) {
        String type = ruleObject.getString("type");
        joinStepElement.setType(type);
        String dataLeft = ruleObject.getString("data_lt");
        String dataRight = ruleObject.getString("data_rt");
        List leftFields = null;
        if (ruleObject.containsKey((Object)"left_fields")) {
            leftFields = ruleObject.getJSONArray("left_fields").toJavaList(String.class);
        }
        List rightFields = null;
        if (ruleObject.containsKey((Object)"right_fields")) {
            rightFields = ruleObject.getJSONArray("right_fields").toJavaList(String.class);
        }
        List selectLtFields = null;
        List selectRtFields = null;
        if (ruleObject.containsKey((Object)"select_lt_fields")) {
            selectLtFields = ruleObject.getJSONArray("select_lt_fields").toJavaList(JSONObject.class);
        }
        if (ruleObject.containsKey((Object)"select_rt_fields")) {
            selectRtFields = ruleObject.getJSONArray("select_rt_fields").toJavaList(JSONObject.class);
        }
        if (StringUtils.isNotEmpty((CharSequence)dataLeft)) {
            joinStepElement.setDataLt(dataLeft);
        }
        if (StringUtils.isNotEmpty((CharSequence)dataRight)) {
            joinStepElement.setDataRt(dataRight);
        }
        ArrayList<JoinSelectElement> selectLtFieldList = null;
        if (ruleObject.containsKey((Object)"select_lt_fields")) {
            selectLtFieldList = new ArrayList<JoinSelectElement>();
            for (JSONObject selectLtFieldObj : selectLtFields) {
                JoinSelectElement joinSelectElement = new JoinSelectElement();
                joinSelectElement.setField(selectLtFieldObj.getString("field"));
                joinSelectElement.setNewField(selectLtFieldObj.getString("newField"));
                selectLtFieldList.add(joinSelectElement);
            }
        }
        ArrayList<JoinSelectElement> selectRtFieldList = null;
        if (ruleObject.containsKey((Object)"select_rt_fields")) {
            selectRtFieldList = new ArrayList<JoinSelectElement>();
            for (JSONObject selectRtFieldObj : selectRtFields) {
                JoinSelectElement joinSelectElement = new JoinSelectElement();
                joinSelectElement.setField(selectRtFieldObj.getString("field"));
                joinSelectElement.setNewField(selectRtFieldObj.getString("newField"));
                selectRtFieldList.add(joinSelectElement);
            }
        }
        joinStepElement.setSelectLtFields(selectLtFieldList);
        joinStepElement.setSelectRtFields(selectRtFieldList);
        joinStepElement.setLeftFields(leftFields);
        joinStepElement.setRightFields(rightFields);
        return joinStepElement;
    }

    private static StepElement parseNumberRange(JSONObject ruleObject, StepElement numberRangeStepElement) {
        String newField = ruleObject.getString("newField");
        String column = ruleObject.getString("column");
        String defaultValue = ruleObject.getString("defaultValue");
        String defaultValueType = ruleObject.getString("defaultValueType");
        String defaultValueDataType = ruleObject.getString("defaultValueDataType");
        List numberRangeRules = ruleObject.getJSONArray("rule").toJavaList(JSONObject.class);
        ArrayList<NumberRangeRuleElement> rules = new ArrayList<NumberRangeRuleElement>();
        for (JSONObject ruleObj : numberRangeRules) {
            NumberRangeRuleElement numberRangeRuleElement = new NumberRangeRuleElement();
            numberRangeRuleElement.setLower(ruleObj.getString("lower"));
            numberRangeRuleElement.setLowerType(ruleObj.getString("lowerType"));
            numberRangeRuleElement.setLowerDataType(ruleObj.getString("lowerDataType"));
            numberRangeRuleElement.setUpper(ruleObj.getString("upper"));
            numberRangeRuleElement.setUpperType(ruleObj.getString("upperType"));
            numberRangeRuleElement.setUpperDataType(ruleObj.getString("upperDataType"));
            numberRangeRuleElement.setValue(ruleObj.getString("value"));
            numberRangeRuleElement.setDecision(ruleObj.getString("decision"));
            numberRangeRuleElement.setValueType(ruleObj.getString("valueType"));
            numberRangeRuleElement.setValueDataType(ruleObj.getString("valueDataType"));
            rules.add(numberRangeRuleElement);
        }
        numberRangeStepElement.setNewField(newField);
        numberRangeStepElement.setColumn(column);
        numberRangeStepElement.setDefaultValue(defaultValue);
        numberRangeStepElement.setRule(rules);
        numberRangeStepElement.setDefaultValueType(defaultValueType);
        numberRangeStepElement.setDefaultValueDataType(defaultValueDataType);
        return numberRangeStepElement;
    }

    private static StepElement parseGetRuntimeInfo(JSONObject ruleObject, StepElement getRuntimeInfoStepElement) {
        List runtimeInfoRules = ruleObject.getJSONArray("rule").toJavaList(JSONObject.class);
        ArrayList<RuntimeInfoElement> rules = new ArrayList<RuntimeInfoElement>();
        for (JSONObject ruleObj : runtimeInfoRules) {
            RuntimeInfoElement runtimeInfoElement = new RuntimeInfoElement();
            Object format = ruleObj.get((Object)"format");
            Object infoType = ruleObj.get((Object)"infoType");
            Object newField = ruleObj.get((Object)"newField");
            Object method = ruleObj.get((Object)"method");
            runtimeInfoElement.setFormat(format == null ? "" : String.valueOf(format));
            runtimeInfoElement.setInfoType(infoType == null ? "" : String.valueOf(infoType));
            runtimeInfoElement.setNewField(newField == null ? "" : String.valueOf(newField));
            runtimeInfoElement.setMethod(method == null ? "" : String.valueOf(method));
            rules.add(runtimeInfoElement);
        }
        getRuntimeInfoStepElement.setRuntimeInfoStepRule(rules);
        return getRuntimeInfoStepElement;
    }

    private static StepElement parseInput(JSONObject ruleObject, StepElement inputStepElement) {
        String path = ruleObject.getString("path");
        inputStepElement.setPath(path);
        String nullDefaultConstruct = ruleObject.getString("nullDefaultConstruct");
        inputStepElement.setNullDefaultConstruct(nullDefaultConstruct);
        return inputStepElement;
    }

    private static StepElement parseDistinct(JSONObject ruleObject, StepElement distinctStepElement) {
        List fieldJsonList = ruleObject.getJSONArray("fields").toJavaList(String.class);
        if (CollectionUtils.isNotEmpty((Collection)fieldJsonList)) {
            distinctStepElement.setFields(fieldJsonList);
        }
        if (ruleObject.containsKey((Object)"returnAll")) {
            distinctStepElement.setReturnAll(ruleObject.getBoolean("returnAll"));
        }
        return distinctStepElement;
    }

    private static StepElement parseMechanism(JSONObject ruleObject, StepElement mechanismStepElement) {
        mechanismStepElement.setVariableName(ruleObject.getString("variable_name"));
        if (ruleObject.containsKey((Object)"eocLevel")) {
            mechanismStepElement.setEocLevel(ruleObject.getString("eocLevel"));
        }
        return mechanismStepElement;
    }

    private static StepElement parseCalculate(JSONObject ruleObject, StepElement calculateStepElement) {
        List ruleObjs = ruleObject.getJSONArray("rule").toJavaList(JSONObject.class);
        return TransAnalysisUtils.parseCalculateRule(ruleObjs, calculateStepElement);
    }

    private static StepElement parseCalculateRule(List<JSONObject> ruleObjs, StepElement calculateStepElement) {
        ArrayList<CalculateRuleDto> calculateRuleDtoList = new ArrayList<CalculateRuleDto>();
        for (JSONObject ruleObj : ruleObjs) {
            CalculateRuleDto calculateRuleDto = new CalculateRuleDto();
            calculateRuleDto.setCalcType(ruleObj.getString("calcType"));
            calculateRuleDto.setFieldA(ruleObj.getString("fieldA"));
            calculateRuleDto.setFieldB(ruleObj.getString("fieldB"));
            calculateRuleDto.setFieldC(ruleObj.getString("fieldC"));
            calculateRuleDto.setFormatA(ruleObj.getString("formatA"));
            calculateRuleDto.setFormatB(ruleObj.getString("formatB"));
            calculateRuleDto.setFormatC(ruleObj.getString("formatC"));
            calculateRuleDto.setFieldAType(ruleObj.getString("fieldA_type"));
            calculateRuleDto.setFieldBType(ruleObj.getString("fieldB_type"));
            calculateRuleDto.setFieldCType(ruleObj.getString("fieldC_type"));
            calculateRuleDto.setNewField(ruleObj.getString("newField"));
            calculateRuleDto.setValueType(ruleObj.getString("valueType"));
            calculateRuleDto.setSuffix(ruleObj.getString("suffix"));
            if (!ruleObj.containsKey((Object)"valueType")) {
                calculateRuleDto.setValueType("number");
            }
            calculateRuleDto.setValueLength(ruleObj.getString("valueLength"));
            calculateRuleDto.setPrecision(ruleObj.getString("precision"));
            if (calculateRuleDto.getCalcType().equals("Divide") && !ruleObj.containsKey((Object)"precision")) {
                calculateRuleDto.setPrecision("2");
            }
            calculateRuleDto.setRetain(ruleObj.getString("retain"));
            calculateRuleDto.setIntervalDays(ruleObj.getIntValue("intervalDays"));
            calculateRuleDto.setPrecisionType(ruleObj.getString("precisionType"));
            if (calculateRuleDto.getCalcType().equals("Divide") && !ruleObj.containsKey((Object)"precisionType")) {
                calculateRuleDto.setPrecisionType("rounding");
            }
            calculateRuleDto.setExceptionHandling(ruleObj.getString("exceptionHandling"));
            if (calculateRuleDto.getCalcType().equals("Divide") && !ruleObj.containsKey((Object)"exceptionHandling")) {
                calculateRuleDto.setExceptionHandling("divideDefault");
            }
            if (calculateRuleDto.getCalcType().equals("Rooting") && !ruleObj.containsKey((Object)"exceptionHandling")) {
                calculateRuleDto.setExceptionHandling("baseLessThanZero");
            }
            if (calculateRuleDto.getCalcType().equals("MOM") && !ruleObj.containsKey((Object)"exceptionHandling")) {
                calculateRuleDto.setExceptionHandling("divideDefault");
            }
            calculateRuleDtoList.add(calculateRuleDto);
        }
        calculateStepElement.setCalculateRuleDtoList(calculateRuleDtoList);
        return calculateStepElement;
    }

    private static StepElement parseCollect(JSONObject ruleObject, StepElement collectStepElement) {
        List conditionList;
        Boolean isTruncateKey = ruleObject.getBoolean("isTruncateKey");
        if (isTruncateKey != null) {
            collectStepElement.setTruncateKey(isTruncateKey);
        }
        if (ruleObject.containsKey((Object)"condition") && CollectionUtils.isNotEmpty((Collection)(conditionList = ruleObject.getJSONArray("condition").toJavaList(JSONObject.class)))) {
            ArrayList<CollectCondition> collectConditionList = new ArrayList<CollectCondition>();
            for (JSONObject conditionObj : conditionList) {
                CollectCondition collectCondition = new CollectCondition();
                collectCondition.setType(conditionObj.getString("type"));
                collectCondition.setNewField(conditionObj.getString("newField"));
                List fieldList = conditionObj.getJSONArray("fields").toJavaList(String.class);
                if (CollectionUtils.isNotEmpty((Collection)fieldList)) {
                    collectCondition.setFileds(fieldList);
                }
                collectConditionList.add(collectCondition);
            }
            collectStepElement.setCollectConditions(collectConditionList);
        }
        return collectStepElement;
    }

    private static StepElement parseGroup(JSONObject ruleObject, StepElement groupStepElement) {
        ArrayList<Statistic> statisticList = new ArrayList<Statistic>();
        groupStepElement.setStatistics(statisticList);
        JSONObject conditionObj = ruleObject.getJSONObject("condition");
        List fieldJsonList = conditionObj.getJSONArray("fields").toJavaList(String.class);
        if (CollectionUtils.isNotEmpty((Collection)fieldJsonList)) {
            groupStepElement.setFields(fieldJsonList);
        }
        List staticsList = conditionObj.getJSONArray("statistics").toJavaList(JSONObject.class);
        for (JSONObject staticsObj : staticsList) {
            List staticList;
            Statistic statistic = new Statistic();
            statistic.setStatisticalMethod(staticsObj.getString("statisticalMethod"));
            statistic.setNewField(staticsObj.getString("newField"));
            statistic.setPrecision(staticsObj.getString("precision"));
            statistic.setPrecisionType(staticsObj.getString("precisionType"));
            statistic.setType(TransAnalysisUtils.getObjectString(staticsObj.get((Object)"type")));
            if (staticsObj.getJSONArray("statisticalFields") != null && CollectionUtils.isNotEmpty((Collection)(staticList = staticsObj.getJSONArray("statisticalFields").toJavaList(String.class)))) {
                statistic.setStatisticalFields(staticList);
            }
            if (null == staticsObj.get((Object)"exceptionHandling")) {
                statistic.setExceptionHandling("divideDefault");
            }
            statistic.setSortName(TransAnalysisUtils.getObjectString(staticsObj.get((Object)"sortName")));
            statistic.setMode(TransAnalysisUtils.getObjectString(staticsObj.get((Object)"mode")));
            statistic.setDirection(TransAnalysisUtils.getObjectString(staticsObj.get((Object)"direction")));
            statistic.setStartPos(TransAnalysisUtils.getObjectString(staticsObj.get((Object)"startPos")));
            statistic.setEndPos(TransAnalysisUtils.getObjectString(staticsObj.get((Object)"endPos")));
            statistic.setRate(TransAnalysisUtils.getObjectString(staticsObj.get((Object)"rate")));
            statistic.setMaximumIterations(TransAnalysisUtils.getObjectString(staticsObj.get((Object)"maximumIterations")));
            statisticList.add(statistic);
        }
        return groupStepElement;
    }

    private static String getObjectString(Object value) {
        if (value == null) {
            return "";
        }
        return String.valueOf(value);
    }

    private static StepElement parseFilter(JSONObject ruleObject, StepElement filterStepElement) {
        filterStepElement.setIsEject(ruleObject.getBoolean("isEject"));
        filterStepElement.setNullJudge(ruleObject.getString("nullJudge"));
        JSONObject conditionsObj = ruleObject.getJSONObject("condition");
        return TransAnalysisUtils.parseRefactorFilter(conditionsObj, filterStepElement);
    }

    private static StepElement parseRefactorFilter(JSONObject conditionsObj, StepElement filterStepElement) {
        ArrayList<FilterItem> itemList = new ArrayList<FilterItem>();
        TransAnalysisUtils.analysisSingleFilterItem(conditionsObj, itemList);
        filterStepElement.setRules(itemList);
        return filterStepElement;
    }

    private static void analysisNestingFilterItem(JSONObject conditionsObj, List<FilterItem> itemList) {
        List items = conditionsObj.getJSONArray("items").toJavaList(JSONObject.class);
        for (JSONObject item : items) {
            TransAnalysisUtils.analysisSingleFilterItem(item, itemList);
        }
    }

    private static void analysisSingleFilterItem(JSONObject subConditionObj, List<FilterItem> itemList) {
        FilterItem filterItem = new FilterItem();
        String logiType = subConditionObj.getString("logitype");
        filterItem.setLogiType(logiType);
        if ("single".equalsIgnoreCase(logiType)) {
            filterItem.setLeft(subConditionObj.getString("left"));
            filterItem.setLeftValueType(subConditionObj.getString("left_value_type"));
            filterItem.setOp(subConditionObj.getString("op"));
            filterItem.setRight(subConditionObj.getString("right"));
            filterItem.setRightValueType(subConditionObj.getString("right_value_type"));
            filterItem.setType(subConditionObj.getString("type"));
            Object leftDateFormat = subConditionObj.get((Object)"left_date_format");
            Object rightDateFormat = subConditionObj.get((Object)"right_date_format");
            filterItem.setLeftDateFormat(leftDateFormat == null ? null : String.valueOf(leftDateFormat));
            filterItem.setRightDateFormat(rightDateFormat == null ? null : String.valueOf(rightDateFormat));
        } else {
            ArrayList<FilterItem> innerItemList = new ArrayList<FilterItem>();
            TransAnalysisUtils.analysisNestingFilterItem(subConditionObj, innerItemList);
            filterItem.setFilterItems(innerItemList);
        }
        itemList.add(filterItem);
    }
}

