/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.dto.ErrorCodeDto;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import com.digiwin.athena.executionengine.exception.ResponseStatusException;
import com.digiwin.athena.executionengine.util.ContextUtils;
import com.digiwin.athena.executionengine.util.ExceptionUtils;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.client.UnknownHttpStatusCodeException;

@Component
@EnableRetry
@EnableAsync(proxyTargetClass=true)
public class HttpClientUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientUtils.class);
    private static final String METHOD_POST = "POST";
    private static final String METHOD_GET = "GET";
    @Autowired(required=false)
    @Qualifier(value="dwAttemptHttpLoadbalanceRoute")
    HttpRoutePlanner httpRoutePlanner;

    @Bean(value={"ee-resttemplate"})
    public RestTemplate restTemplate(@Qualifier(value="ee-resttemplate-requestfactory") ClientHttpRequestFactory httpRequestFactory) {
        RestTemplate restTemplate = new RestTemplate(httpRequestFactory);
        restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        return restTemplate;
    }

    @Bean(value={"ee-resttemplate-requestfactory"})
    public ClientHttpRequestFactory httpRequestFactory(@Qualifier(value="dw-httpclient-request-retry-handler") HttpRequestRetryHandler requestRetryHandler, @Qualifier(value="dw-httpclient-response-retry-strategy") ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy) {
        HttpClientBuilder builder = HttpClientBuilder.create().setRetryHandler(requestRetryHandler).setServiceUnavailableRetryStrategy(serviceUnavailableRetryStrategy);
        PoolingHttpClientConnectionManager connectionManager = this.getConnectionManager();
        connectionManager.setMaxTotal(ModuleProperty.HTTP_MAXTOTAL);
        connectionManager.setDefaultMaxPerRoute(ModuleProperty.HTTP_MAXPERROUTE);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(ModuleProperty.HTTP_SOCKE_TTIMEOUT).setConnectTimeout(ModuleProperty.HTTP_CONNECT_TIMEOUT).setConnectionRequestTimeout(ModuleProperty.HTTP_REQUEST_TIMEOUT).build();
        builder.setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).setRoutePlanner(this.httpRoutePlanner).build();
        CloseableHttpClient httpClient = builder.build();
        HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        return clientHttpRequestFactory;
    }

    @Bean(value={"httpClientConnectionManager"})
    public PoolingHttpClientConnectionManager getConnectionManager() {
        return new PoolingHttpClientConnectionManager();
    }

    public static String doRequest(String method, String url, Map<String, String> headers, Map<String, Object> params) {
        if (METHOD_POST.equalsIgnoreCase(method)) {
            return HttpClientUtils.doPost(url, headers, JSONObject.toJSONString(params, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.QuoteFieldNames}));
        }
        if (METHOD_GET.equalsIgnoreCase(method)) {
            return HttpClientUtils.doGet(url, headers, params);
        }
        return null;
    }

    public static String doPost(String url, Map<String, String> headers, String jsonParams) {
        String respContent = null;
        try {
            HttpEntity httpEntity = new HttpEntity((Object)jsonParams, (MultiValueMap)HttpClientUtils.getSpringHttpHeader(headers));
            ResponseEntity responseEntity = ContextUtils.getBean(RestTemplate.class, new Object[0]).postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
            int statusCode = responseEntity.getStatusCodeValue();
            if (statusCode != 200) {
                throw ExceptionUtils.buildResponseStatusException(ErrorCodeEnum.HTTP_RESPONSE_FAIL_STATUS, METHOD_POST, url, String.valueOf(statusCode));
            }
            respContent = (String)responseEntity.getBody();
        }
        catch (HttpClientErrorException e) {
            LOGGER.error("doPost\u8bf7\u6c42[" + url + "]\u51fa\u73b0\u5ba2\u6237\u7aef4XX\u5f02\u5e38\uff01\u54cd\u5e94\u62a5\u6587\u4e3a\uff1a" + e.getResponseBodyAsString(), (Throwable)e);
            ResponseStatusException responseStatusException = ExceptionUtils.buildResponseStatusException(ErrorCodeEnum.HTTP_CLIENT_EXCEPTION, METHOD_POST, url, e.getResponseBodyAsString());
            responseStatusException.getInstructors().put("chainInfo", HttpClientUtils.getChainInfo(e.getResponseBodyAsString()));
            throw responseStatusException;
        }
        catch (HttpServerErrorException e) {
            LOGGER.error("doPost\u8bf7\u6c42[" + url + "]\u51fa\u73b0\u670d\u52a1\u7aef5XX\u5f02\u5e38\uff01\u54cd\u5e94\u62a5\u6587\u4e3a\uff1a" + e.getResponseBodyAsString(), (Throwable)e);
            ErrorCodeDto errorCodeDto = HttpClientUtils.parseErrorInfo(e.getResponseBodyAsString());
            ResponseStatusException responseStatusException = errorCodeDto != null ? new ResponseStatusException(errorCodeDto.getErrorCode(), errorCodeDto.getMessage(), e.getResponseBodyAsString()) : ExceptionUtils.buildResponseStatusException(ErrorCodeEnum.HTTP_SERVER_EXCEPTION, METHOD_POST, url, e.getResponseBodyAsString());
            responseStatusException.getInstructors().put("chainInfo", HttpClientUtils.getChainInfo(e.getResponseBodyAsString()));
            throw responseStatusException;
        }
        catch (UnknownHttpStatusCodeException e) {
            LOGGER.error("doPost\u8bf7\u6c42[" + url + "]\u51fa\u73b0\u672a\u77e5\u72b6\u6001\u7801\u5f02\u5e38\uff01\u54cd\u5e94\u62a5\u6587\u4e3a\uff1a" + e.getResponseBodyAsString(), (Throwable)e);
            ResponseStatusException responseStatusException = ExceptionUtils.buildResponseStatusException(ErrorCodeEnum.HTTP_UNKNOWN_STATUS_EXCEPTION, METHOD_POST, url, e.getResponseBodyAsString());
            responseStatusException.getInstructors().put("chainInfo", HttpClientUtils.getChainInfo(e.getResponseBodyAsString()));
            throw responseStatusException;
        }
        catch (Exception e) {
            LOGGER.error("[{" + url + "}]post\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
            throw ExceptionUtils.buildResponseStatusException(ErrorCodeEnum.HTTP_UNKNOWN_EXCEPTION, METHOD_POST, url);
        }
        finally {
            if (respContent == null) {
                LOGGER.error("httpClient post\u8bf7\u6c42\u9519\u8bef \u8bf7\u6c42url\uff1a{}", (Object)url);
                LOGGER.error("httpClient post\u8bf7\u6c42\u9519\u8bef \u8bf7\u6c42header\uff1a{}", headers);
                LOGGER.error("httpClient post\u8bf7\u6c42\u9519\u8bef \u8bf7\u6c42\u5165\u53c2\uff1a{}", (Object)jsonParams);
            }
        }
        return respContent;
    }

    private static HttpHeaders getSpringHttpHeader(Map<String, String> headers) {
        HttpHeaders springHttpHeader = new HttpHeaders();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            springHttpHeader.set(entry.getKey(), entry.getValue());
        }
        return springHttpHeader;
    }

    private static String doGet(String url, Map<String, String> headers, Map<String, Object> param) {
        String respContent = null;
        try {
            boolean isNeedDecode = true;
            HashMap<String, String> paramMap = new HashMap<String, String>();
            if (MapUtils.isNotEmpty(param)) {
                StringBuilder sbParam = new StringBuilder("?");
                for (Map.Entry<String, Object> entry : param.entrySet()) {
                    sbParam.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue().toString(), "UTF-8")).append("&");
                }
                url = url + sbParam;
            } else {
                String[] urlParams = url.split("\\?");
                if (urlParams.length > 1) {
                    String[] params = urlParams[1].split("&");
                    String urlParamUnion = "";
                    for (String para : params) {
                        String[] keyValue = para.split("=");
                        String key = keyValue[0];
                        String value = keyValue[1];
                        LOGGER.info("Param: {}, Value: {}", (Object)key, (Object)value);
                        urlParamUnion = urlParamUnion + key + "={" + key + "}&";
                        paramMap.put(key, URLDecoder.decode(value, "utf-8"));
                    }
                    url = urlParams[0] + "?" + urlParamUnion;
                    LOGGER.info("doGet\u8c03\u7528url: {}", (Object)url);
                    isNeedDecode = false;
                }
            }
            if (isNeedDecode) {
                url = URLDecoder.decode(url, "utf-8");
            }
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)HttpClientUtils.getSpringHttpHeader(headers));
            ResponseEntity responseEntity = ContextUtils.getBean(RestTemplate.class, new Object[0]).exchange(url, HttpMethod.GET, httpEntity, String.class, paramMap);
            int statusCode = responseEntity.getStatusCodeValue();
            if (statusCode != 200) {
                throw ExceptionUtils.buildResponseStatusException(ErrorCodeEnum.HTTP_RESPONSE_FAIL_STATUS, METHOD_GET, url, String.valueOf(statusCode));
            }
            respContent = (String)responseEntity.getBody();
        }
        catch (HttpClientErrorException e) {
            LOGGER.error("doGet\u8bf7\u6c42[" + url + "]\u51fa\u73b0\u5ba2\u6237\u7aef4XX\u5f02\u5e38\uff01\u54cd\u5e94\u62a5\u6587\u4e3a\uff1a" + e.getResponseBodyAsString(), (Throwable)e);
            ResponseStatusException responseStatusException = ExceptionUtils.buildResponseStatusException(ErrorCodeEnum.HTTP_CLIENT_EXCEPTION, METHOD_GET, url, e.getResponseBodyAsString());
            responseStatusException.getInstructors().put("chainInfo", HttpClientUtils.getChainInfo(e.getResponseBodyAsString()));
            throw responseStatusException;
        }
        catch (HttpServerErrorException e) {
            LOGGER.error("doGet\u8bf7\u6c42[" + url + "]\u51fa\u73b0\u670d\u52a1\u7aef5XX\u5f02\u5e38\uff01\u54cd\u5e94\u62a5\u6587\u4e3a\uff1a" + e.getResponseBodyAsString(), (Throwable)e);
            ErrorCodeDto errorCodeDto = HttpClientUtils.parseErrorInfo(e.getResponseBodyAsString());
            ResponseStatusException responseStatusException = errorCodeDto != null ? new ResponseStatusException(errorCodeDto.getErrorCode(), errorCodeDto.getMessage(), e.getResponseBodyAsString()) : ExceptionUtils.buildResponseStatusException(ErrorCodeEnum.HTTP_SERVER_EXCEPTION, METHOD_GET, url, e.getResponseBodyAsString());
            responseStatusException.getInstructors().put("chainInfo", HttpClientUtils.getChainInfo(e.getResponseBodyAsString()));
            throw responseStatusException;
        }
        catch (UnknownHttpStatusCodeException e) {
            LOGGER.error("doGet\u8bf7\u6c42[" + url + "]\u51fa\u73b0\u672a\u77e5\u72b6\u6001\u7801\u5f02\u5e38\uff01\u54cd\u5e94\u62a5\u6587\u4e3a\uff1a" + e.getResponseBodyAsString(), (Throwable)e);
            ResponseStatusException responseStatusException = ExceptionUtils.buildResponseStatusException(ErrorCodeEnum.HTTP_UNKNOWN_STATUS_EXCEPTION, METHOD_GET, url, e.getResponseBodyAsString());
            responseStatusException.getInstructors().put("chainInfo", HttpClientUtils.getChainInfo(e.getResponseBodyAsString()));
            throw responseStatusException;
        }
        catch (Exception e) {
            LOGGER.error("[{" + url + "}]get\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            throw ExceptionUtils.buildResponseStatusException(ErrorCodeEnum.HTTP_UNKNOWN_EXCEPTION, METHOD_GET, url);
        }
        finally {
            if (respContent == null) {
                LOGGER.error("httpClient get\u8bf7\u6c42\u9519\u8bef \u8bf7\u6c42url\uff1a{}", (Object)url);
                LOGGER.error("httpClient get\u8bf7\u6c42\u9519\u8bef \u8bf7\u6c42header\uff1a{}", headers);
                LOGGER.error("httpClient get\u8bf7\u6c42\u9519\u8bef \u8bf7\u6c42\u5165\u53c2\uff1a{}", param);
            }
        }
        return respContent;
    }

    private static ErrorCodeDto parseErrorInfo(String message) {
        String errorCode = Optional.ofNullable(JSONObject.parseObject((String)message)).map(item -> item.getString("errorCode")).orElse(null);
        String errorMessage = Optional.ofNullable(JSONObject.parseObject((String)message)).map(item -> item.getString("errorMessage")).orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)errorCode) && StringUtils.isNotEmpty((CharSequence)errorMessage)) {
            return new ErrorCodeDto(errorCode, errorMessage);
        }
        return null;
    }

    public static String getChainInfo(String message) {
        return Optional.ofNullable(HttpClientUtils.getErrorInstructors(message)).map(item -> item.getString("chainInfo")).orElse(null);
    }

    private static JSONObject getErrorInstructors(String message) {
        return Optional.ofNullable(JSONObject.parseObject((String)message)).map(item -> item.getJSONObject("errorInstructors")).orElse(null);
    }
}

